/*
 * Decompiled with CFR 0.152.
 */
package plug.statespace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.IStateSpaceManager;
import plug.statespace.IConfigurationStorage;
import plug.statespace.IGraphAccess;
import plug.statespace.ITransitionStorage;
import plug.statespace.configurations.CountingConfigurationStorage;
import plug.statespace.configurations.FullConfigurationStorage;
import plug.statespace.configurations.MockConfigurationStorage;
import plug.statespace.graph.CountingTransitionStorage;
import plug.statespace.graph.FullTransitionStorage;
import plug.statespace.graph.MockTransitionStorage;
import plug.statespace.graph.ParentTransitionStorage;

public class SimpleStateSpaceManager<C extends IConfiguration, A>
implements IStateSpaceManager<C, A>,
IGraphAccess<C, A> {
    Set<C> initialConfigurations = new HashSet<C>();
    IConfigurationStorage<C> configurationStorage;
    ITransitionStorage<C, A> transitionStorage;

    public SimpleStateSpaceManager() {
        this(false);
    }

    public SimpleStateSpaceManager(boolean fullTransition) {
        this.fullConfigurationStorage();
        if (fullTransition) {
            this.fullTransitionStorage();
        } else {
            this.noTransitionStorage();
        }
    }

    @Override
    public IStateSpaceManager<C, A> noConfigurationStorage() {
        this.configurationStorage = new MockConfigurationStorage();
        return this;
    }

    @Override
    public IStateSpaceManager<C, A> countingConfigurationStorage() {
        this.configurationStorage = new CountingConfigurationStorage();
        return this;
    }

    @Override
    public IStateSpaceManager<C, A> fullConfigurationStorage() {
        this.configurationStorage = new FullConfigurationStorage();
        ((FullConfigurationStorage)this.configurationStorage).setStorageBackend(new HashMap());
        return this;
    }

    @Override
    public IStateSpaceManager<C, A> noTransitionStorage() {
        this.transitionStorage = new MockTransitionStorage();
        return this;
    }

    @Override
    public IStateSpaceManager<C, A> countingTransitionStorage() {
        this.transitionStorage = new CountingTransitionStorage();
        return this;
    }

    @Override
    public IStateSpaceManager<C, A> parentTransitionStorage() {
        this.transitionStorage = new ParentTransitionStorage();
        return this;
    }

    @Override
    public IStateSpaceManager<C, A> fullTransitionStorage() {
        this.transitionStorage = new FullTransitionStorage();
        return this;
    }

    @Override
    public Set<C> initialConfigurations() {
        return this.initialConfigurations;
    }

    @Override
    public IFiredTransition putTransition(IFiredTransition<C, A> transition) {
        assert (transition.getTargets() != null && !transition.getTargets().isEmpty());
        return this.transitionStorage.put(transition);
    }

    @Override
    public synchronized C get(C state) {
        return (C)((IConfiguration)this.configurationStorage.get(state));
    }

    @Override
    public synchronized C put(C state) {
        return (C)((IConfiguration)this.configurationStorage.put(state));
    }

    @Override
    public synchronized C putInitial(C state) {
        this.initialConfigurations.add(state);
        return (C)((IConfiguration)this.configurationStorage.put(state));
    }

    @Override
    public int size() {
        return this.configurationStorage.size();
    }

    @Override
    public int transitionCount() {
        return this.transitionStorage.size();
    }

    public Collection<C> getInitialVertices() {
        return this.initialConfigurations;
    }

    public Collection<C> getSources() {
        return this.initialConfigurations;
    }

    public Collection<C> getSinks() {
        ArrayList<IConfiguration> result = new ArrayList<IConfiguration>();
        for (IConfiguration reached : this.getVertices()) {
            if (!this.getOutgoingEdges((C)reached).isEmpty()) continue;
            result.add(reached);
        }
        return result;
    }

    public Collection<C> getVertices() {
        return this.configurationStorage.getConfigurations();
    }

    public C getParent(C vertex) {
        return this.transitionStorage.getParent(vertex);
    }

    public Collection<C> fanout(C vertex) {
        HashSet<C> targets = new HashSet<C>();
        for (IFiredTransition<C, A> fired : this.transitionStorage.getFiredFrom(vertex)) {
            targets.addAll(fired.getTargets());
        }
        return targets;
    }

    public Collection<IFiredTransition<C, A>> getOutgoingEdges(C vertex) {
        return this.transitionStorage.getFiredFrom(vertex);
    }

    public Collection<IFiredTransition<C, A>> getIncomingEdges(C vertex) {
        return this.transitionStorage.getFiredTo(vertex);
    }

    @Override
    public IGraphAccess<C, A> getGraphView() {
        return this;
    }

    public int getVertexCount() {
        return this.size();
    }

    public int getEdgeCount() {
        return this.transitionStorage.getEdgeCount();
    }
}

