/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import obp.explorer.runtime.SymbolsTable;
import obp.lua.LuaUtil;
import org.luaj.vm2.LuaValue;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;

public class EventImpl
implements BoostObject {
    public static final EventImpl NIL = new EventImpl(-1, -1, LuaValue.NIL);
    public final short id;
    public final short destinationId;
    public final LuaValue value;

    public EventImpl(short id, short destinationId, LuaValue value) {
        this.id = id;
        this.destinationId = destinationId;
        this.value = value;
    }

    protected EventImpl(Boost boost) {
        boost.register((BoostObject)this);
        this.id = boost.readShort();
        this.destinationId = boost.readShort();
        this.value = LuaUtil.readFromBoost(boost);
    }

    public boolean isNil() {
        return this == NIL;
    }

    public void writeToBoost(Boost boost) {
        boost.writeShort(this.id);
        boost.writeShort(this.destinationId);
        LuaUtil.writeToBoost(this.value, boost);
    }

    public boolean equals(Object object) {
        if (object instanceof EventImpl) {
            EventImpl other = (EventImpl)object;
            return this.id == other.id && this.destinationId == other.destinationId && this.value != null ? this.value.equals((Object)other.value) : other.value == null;
        }
        return false;
    }

    public int hashCode() {
        int code = 27;
        code = 37 * code + this.id;
        code = 37 * code + this.destinationId;
        if (this.value != null) {
            code = 37 * code + this.value.hashCode();
        }
        return code;
    }

    public String toString() {
        return this.toFancyString(null);
    }

    public String toFancyString(SymbolsTable symbols) {
        StringBuilder text = new StringBuilder();
        text.append(symbols != null ? symbols.getEventName(this.id) : Short.valueOf(this.id));
        text.append("(");
        if (this.value != null) {
            text.append(this.value);
        }
        text.append(")");
        text.append(" to ");
        text.append(symbols != null ? symbols.getBehaviorName(this.destinationId) : Short.valueOf(this.destinationId));
        return text.toString();
    }
}

