/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.obs;

import java.util.ArrayList;
import java.util.List;
import obp.cdl.EventReference;
import obp.event.Event;
import obp.event.PredicateEvent;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.evaluator.Evaluator;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.fiacre.ActionEventToMatcher;
import obp.explorer.runtime.fiacre.PredicateToEvaluator;
import obp.explorer.runtime.matcher.Matcher;
import obp.explorer.runtime.obs.EventWatcher;
import obp.explorer.runtime.obs.ObsConfiguration;
import obp.explorer.runtime.obs.ObsTransition;
import obp.explorer.runtime.obs.ObsTransitionDefault;
import obp.obs.Observer;
import obp.obs.Reset;
import obp.obs.State;
import obp.obs.Transition;
import obp.obs.Type;
import obp.obs.When;
import obp.predicate.AllPredicate;
import obp.predicate.Predicate;
import obp.property.Scope;
import org.xid.basics.serializer.Boost;

public class ObsBehavior
extends Behavior {
    public static final short Inactive = -1;
    private final Observer observer;
    private final short clockIndex;
    private Tester activeTester;
    private ObsTransition[] transitions;
    private final List<EventWatcher> eventWatchers;
    public boolean isGreedy;

    public ObsBehavior(Observer observer, SymbolsTable symbols) {
        super(symbols.newBehaviorName(observer.getName(), (short)1), symbols);
        this.observer = observer;
        this.isGreedy = observer.isGreedy();
        this.clockIndex = observer.getClock() != null ? symbols.newClockIndex() : (short)-1;
        this.eventWatchers = new ArrayList<EventWatcher>(observer.getTransitionCount());
    }

    @Override
    public void collectBehaviors(List<Behavior> result) {
    }

    @Override
    public int getStateId(String name) {
        if ("inactive".equals(name)) {
            return -1;
        }
        for (int i = 0; i < this.observer.getStateCount(); i = (int)((short)(i + 1))) {
            State state = this.observer.getState(i);
            if (!name.equals(state.getName())) continue;
            return i;
        }
        throw new IllegalArgumentException("State '" + name + "' doesn't exist in observer '" + this.name + "'.");
    }

    @Override
    public void link(ExplorationContext context, SymbolsTable symbols) {
        try {
            Scope scope = this.observer.getScope();
            this.activeTester = this.predicateToTester(scope == null ? null : scope.getPredicate(), context, symbols);
            ArrayList<ObsTransition> transitionsList = new ArrayList<ObsTransition>(this.observer.getTransitionCount() + 1);
            if (scope != null) {
                transitionsList.add(this.createActivateTransition());
                if (scope.isStrong()) {
                    transitionsList.add(this.createDeactivateTransition());
                }
            }
            for (Transition transition : this.observer.getTransitionList()) {
                this.checkWhenAndReset(transition.getWhen(), transition.getReset());
                short sourceState = this.getObserverStateId(transition.getSource());
                short targetState = this.getObserverStateIdForTarget(transition.getTarget());
                Tester guardTester = this.predicateToTester(transition.getGuard(), context, symbols);
                short[] when = this.getWhenValue(transition.getWhen());
                int reset = this.getResetValue(transition.getReset());
                short[] eventIds = new short[transition.getEventsCount()];
                for (int i = 0; i < transition.getEventsCount(); ++i) {
                    eventIds[i] = this.getEventId(transition.getEvents(i), context, symbols);
                }
                ObsTransitionDefault obsTransition = new ObsTransitionDefault(this.id, this.clockIndex, when, sourceState, guardTester, eventIds, targetState, reset);
                transitionsList.add(obsTransition);
            }
            this.transitions = transitionsList.toArray(new ObsTransition[transitionsList.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<EventWatcher> getEventWatchers() {
        return this.eventWatchers;
    }

    private Tester predicateToTester(Predicate predicate, ExplorationContext context, SymbolsTable symbols) {
        if (predicate == null) {
            predicate = new AllPredicate();
        }
        Evaluator matcher = PredicateToEvaluator.toEvaluator(predicate, context, symbols);
        return new Tester(matcher);
    }

    private short getObserverStateId(State state) {
        return (short)this.observer.getStateList().indexOf(state);
    }

    private short getObserverStateIdForTarget(State state) {
        if (state == this.observer.getStartState() && this.observer.getScope() != null) {
            return -1;
        }
        return (short)this.observer.getStateList().indexOf(state);
    }

    private short[] getWhenValue(When when) {
        if (when == null) {
            return null;
        }
        switch (when.getType()) {
            case GREATER: {
                return new short[]{0, this.clockIndex, DBM.computeInternal(-when.getValue(), true)};
            }
            case GREATER_OR_EQUAL: {
                return new short[]{0, this.clockIndex, DBM.computeInternal(-when.getValue(), false)};
            }
            case LESSER: {
                return new short[]{this.clockIndex, 0, DBM.computeInternal(when.getValue(), true)};
            }
            case LESSER_OR_EQUAL: {
                return new short[]{this.clockIndex, 0, DBM.computeInternal(when.getValue(), false)};
            }
        }
        return null;
    }

    private int getResetValue(Reset reset) {
        return reset == null ? -2 : reset.getValue();
    }

    private void checkWhenAndReset(When when, Reset reset) {
        if (when != null && !when.getClock().equals(this.observer.getClock())) {
            throw new IllegalArgumentException("There is no clock named '" + when.getClock() + "' in observer '" + this.observer.getName() + "'.");
        }
        if (reset != null && !reset.getClock().equals(this.observer.getClock())) {
            throw new IllegalArgumentException("There is no clock named '" + reset.getClock() + "' in observer '" + this.observer.getName() + "'.");
        }
    }

    private short getEventId(EventReference reference, ExplorationContext context, SymbolsTable symbols) {
        if (reference == null) {
            return -1;
        }
        String eventName = reference.getName();
        if (symbols.doesEventExist(eventName)) {
            return symbols.getEventId(eventName);
        }
        short id = symbols.newEventId(eventName);
        Event event = reference.getReference().getIs();
        if (event instanceof PredicateEvent) {
            Predicate predicate = ((PredicateEvent)event).getPredicate();
            Tester tester = this.predicateToTester(predicate, context, symbols);
            this.eventWatchers.add(new EventWatcher.Predicate(id, tester));
        } else {
            Matcher matcher = ActionEventToMatcher.toMatcher(event, context, symbols);
            this.eventWatchers.add(new EventWatcher.Action(id, matcher));
        }
        return id;
    }

    private ObsTransition createActivateTransition() {
        final short startStateId = this.getObserverStateId(this.observer.getStartState());
        return new ObsTransition(this.id){

            @Override
            public boolean guard(Configuration source, Configuration target) {
                ObsConfiguration me = (ObsConfiguration)target.behaviorConfigurations[ObsBehavior.this.id];
                if (me.state != -1) {
                    return false;
                }
                return ObsBehavior.this.activeTester.test(source);
            }

            @Override
            public void action(Configuration configuration) {
                ObsConfiguration me = (ObsConfiguration)configuration.behaviorConfigurations[ObsBehavior.this.id];
                me.state = startStateId;
            }
        };
    }

    private ObsTransition createDeactivateTransition() {
        final boolean[] sources = new boolean[this.observer.getStateCount()];
        for (int i = 0; i < this.observer.getStateCount(); ++i) {
            State state = this.observer.getState(i);
            Type type = state.getType();
            sources[i] = type == Type.Reject || type == Type.Success;
        }
        return new ObsTransition(this.id){

            @Override
            public boolean guard(Configuration source, Configuration target) {
                ObsConfiguration me = (ObsConfiguration)target.behaviorConfigurations[ObsBehavior.this.id];
                if (me.state == -1 || sources[me.state]) {
                    return false;
                }
                return !ObsBehavior.this.activeTester.test(source);
            }

            @Override
            public void action(Configuration configuration) {
                ObsConfiguration me = (ObsConfiguration)configuration.behaviorConfigurations[ObsBehavior.this.id];
                me.state = (short)-1;
            }
        };
    }

    public ObsTransition[] getTransitions() {
        return this.transitions;
    }

    public boolean isReject(ObsConfiguration me) {
        short state = me.state;
        if (state == -1) {
            return false;
        }
        return this.observer.getState(state).getType() == Type.Reject;
    }

    public boolean isSuccess(ObsConfiguration me) {
        short state = me.state;
        if (state == -1) {
            return false;
        }
        return this.observer.getState(state).getType() == Type.Success;
    }

    public boolean isCut(ObsConfiguration me) {
        short state = me.state;
        if (state == -1) {
            return false;
        }
        return this.observer.getState(state).getType() == Type.Cut;
    }

    @Override
    public ObsConfiguration createInitialConfiguration(Configuration conf) {
        ObsConfiguration me = new ObsConfiguration();
        me.state = this.getObserverStateIdForTarget(this.observer.getStartState());
        return me;
    }

    @Override
    public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        ObsConfiguration obsConfiguration = (ObsConfiguration)behaviorConfiguration;
        StringBuilder text = new StringBuilder();
        text.append("observer: '" + this.name + "'");
        text.append(" [@");
        if (obsConfiguration.state == -1) {
            text.append("inactive");
        } else {
            text.append(this.observer.getState(obsConfiguration.state).getName());
            if (this.isReject(obsConfiguration)) {
                text.append(":error");
            }
        }
        if (this.clockIndex >= 0) {
            text.append(", c");
            text.append(this.clockIndex);
        }
        text.append("]");
        return text.toString();
    }

    @Override
    public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        return this.toStringConfiguration(behaviorConfiguration);
    }

    @Override
    public BehaviorConfiguration readConfiguration(Boost boost) {
        ObsConfiguration me = new ObsConfiguration();
        me.state = boost.readShort();
        return me;
    }

    @Override
    public void writeConfiguration(Boost boost, BehaviorConfiguration behaviorConfiguration) {
        ObsConfiguration obsConfiguration = (ObsConfiguration)behaviorConfiguration;
        boost.writeShort(obsConfiguration.state);
    }
}

