/*
 * Decompiled with CFR 0.152.
 */
package obp;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import obp.OBPController;
import obp.cc.ConcreteContext;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.cdl.PropertyReference;
import obp.explorer.ExplorerResult;
import obp.explorer.ExplorerResultUtil;
import obp.fiacre.model.Program;
import obp.fiacre.transfo.FiacreScrambler;
import obp.fiacre.util.FiacrePrinter;
import obp.fiacre.util.FiacreUtil;
import obp.transfo.cdl.CDLToConcreteContext;
import obp.util.CDLUtil;
import obp.util.ConcreteContextUtil;
import obp.util.FileUtil;
import org.cte.ABCD.fiacre.ABCDUtil;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.generation.MergerUtil;
import org.xid.basics.progress.ActionMonitor;

public class OBPModel {
    private final NumberFormat integerFormat = DecimalFormat.getIntegerInstance();
    private final ErrorHandler errorHandler;
    protected File cdlFile;
    private long cdlFileModifiedDate = -1L;
    private CDLUnit cdlUnit;
    private CDLDeclaration cdl;
    private boolean autoPartition = false;
    private int initialStep = 1;
    private int splitStep = 1;
    private boolean saveConfigurationFile = true;
    private Thread cdlInformationThread;
    private boolean computingCdlInformation = false;
    private boolean cdlInformationUptodate = false;
    protected ConcreteContext concreteContext;
    private BigInteger contextPathCount = null;
    private File completeProgramFile;
    private final List<File> programFileList = new ArrayList<File>();
    private final List<Long> programFileModifiedDate = new ArrayList<Long>();
    private String programSource;
    private boolean programSourceParsable;
    protected boolean compiled = false;
    private boolean noConfs = false;
    private File ccslFile;
    private List<ExplorerResult> explorerResults;
    private String cachedResultsString;
    private boolean isABCD;

    public OBPModel(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler == null ? ErrorHandler.simple : errorHandler;
    }

    private void initCdlAttributes() {
        this.cdlUnit = null;
        this.cdl = null;
        this.concreteContext = null;
        this.cdlInformationUptodate = false;
    }

    public CDLDeclaration getCdl() {
        return this.cdl;
    }

    public void setCdl(CDLDeclaration cdl) {
        this.cdl = cdl;
        this.concreteContext = cdl != null ? CDLToConcreteContext.toConcreteContext(this.cdlUnit, cdl) : null;
    }

    public ConcreteContext getConcreteContext() {
        return this.concreteContext;
    }

    public CDLUnit getCdlUnit() {
        return this.cdlUnit;
    }

    public List<CDLDeclaration> getCdlList() {
        if (this.cdlUnit == null) {
            return Collections.emptyList();
        }
        return CDLUtil.findAllDeclarations(this.cdlUnit, CDLDeclaration.class);
    }

    public File getCdlFile() {
        return this.cdlFile;
    }

    public void setCdlFile(File cdlFile) {
        this.cdlFile = cdlFile;
        String oldCdlName = this.cdl == null ? null : this.cdl.getName();
        this.initCdlAttributes();
        if (cdlFile != null) {
            this.cdlFileModifiedDate = cdlFile.lastModified();
            try {
                this.cdlUnit = CDLUtil.readCDLAndResolveReferences(cdlFile);
                CDLDeclaration newCdl = null;
                if (oldCdlName != null) {
                    newCdl = CDLUtil.findDeclaration(this.cdlUnit, oldCdlName, CDLDeclaration.class);
                }
                List<CDLDeclaration> cdls = this.getCdlList();
                if (newCdl == null && cdls.size() > 0) {
                    newCdl = cdls.get(0);
                }
                this.setCdl(newCdl);
            }
            catch (Exception e) {
                this.errorHandler.handleError(2, DiagnosticUtil.createMessage((Throwable)e) + "\n");
            }
        }
    }

    public boolean isAutoPartition() {
        return this.autoPartition;
    }

    public void setAutoPartition(boolean autoPartition) {
        this.autoPartition = autoPartition;
    }

    public int getInitialStep() {
        return this.initialStep;
    }

    public void setInitialStep(int initialStep) {
        this.initialStep = initialStep;
    }

    public int getSplitStep() {
        return this.splitStep;
    }

    public void setSplitStep(int splitStep) {
        this.splitStep = splitStep;
    }

    public List<File> getProgramFileList() {
        return Collections.unmodifiableList(this.programFileList);
    }

    public void addProgramFile(File programFile) {
        this.programFileList.add(programFile);
        this.refreshProgramSource();
    }

    public void removeProgramFile(File programFile) {
        int index = this.programFileList.indexOf(programFile);
        if (index >= 0) {
            this.programFileList.remove(index);
            this.refreshProgramSource();
        }
    }

    public boolean canUpProgramFile(File programFile) {
        if (programFile == null) {
            return false;
        }
        int index = this.programFileList.indexOf(programFile);
        return index > 0;
    }

    public void upProgramFile(File programFile) {
        int index = this.programFileList.indexOf(programFile);
        this.programFileList.remove(index);
        this.programFileList.add(index - 1, programFile);
        this.refreshProgramSource();
    }

    public boolean canDownProgramFile(File programFile) {
        if (programFile == null) {
            return false;
        }
        int index = this.programFileList.indexOf(programFile);
        return index < this.programFileList.size() - 1;
    }

    public void downProgramFile(File programFile) {
        int index = this.programFileList.indexOf(programFile);
        this.programFileList.remove(index);
        this.programFileList.add(index + 1, programFile);
        this.refreshProgramSource();
    }

    public void clearsProgramFileList() {
        this.programFileList.clear();
        this.refreshProgramSource();
    }

    public void exportScrambledProgram() throws Exception {
        File explorableProgramFile = this.getExplorableProgramFile();
        if (this.isMoCCMLModel(explorableProgramFile)) {
            return;
        }
        String explorableName = explorableProgramFile.getName();
        String name = explorableName.substring(0, explorableName.length() - 4) + "_scrambled.fcr";
        File scrambled = new File(explorableProgramFile.getParentFile(), name);
        Program program = FiacreUtil.loadProgram(this.getExplorableProgramFile());
        FiacreScrambler.scramble(program);
        MergerUtil.writeFile((File)scrambled, (String)FiacrePrinter.toString(program), (String)"UTF-8");
        this.refreshProgramSource();
    }

    private void refreshProgramSource() {
        this.programSource = null;
        this.compiled = false;
        this.completeProgramFile = null;
        this.isABCD = false;
        if (this.programFileList.size() > 1) {
            File parent = this.programFileList.get(0).getParentFile();
            if (parent.getName().endsWith(".abcd")) {
                this.completeProgramFile = new File(parent, "OBPComplete.abcd");
                this.isABCD = true;
            } else {
                this.completeProgramFile = new File(parent, "OBPComplete.fcr");
            }
        }
        if (this.programFileList.size() > 0) {
            StringBuilder source = new StringBuilder();
            for (File programFile : this.programFileList) {
                source.append(FileUtil.loadContents(programFile));
                source.append(System.getProperty("line.separator"));
                if (!programFile.getName().endsWith(".abcd")) continue;
                this.isABCD = true;
            }
            this.programSource = source.toString();
            if (this.completeProgramFile != null) {
                try {
                    MergerUtil.writeFile((File)this.completeProgramFile, (String)this.programSource, (String)"UTF-8");
                }
                catch (Exception e) {
                    this.errorHandler.handleError(2, "Can't create file '" + this.completeProgramFile + "'\n.");
                    return;
                }
                this.errorHandler.handleError(0, "Generated file " + this.completeProgramFile + "'.\n");
            }
            try {
                if (this.isABCD) {
                    this.programSource = ABCDUtil.toFiacre(this.programSource);
                }
                FiacreUtil.loadProgram(this.programSource);
                this.programSourceParsable = true;
            }
            catch (Exception e) {
                this.programSourceParsable = false;
            }
        }
        this.programFileModifiedDate.clear();
        for (File programFile : this.programFileList) {
            this.programFileModifiedDate.add(programFile.lastModified());
        }
    }

    public File getExplorableProgramFile() {
        if (this.programFileList.isEmpty()) {
            if (this.ccslFile != null && this.isMoCCMLModel(this.ccslFile)) {
                return this.ccslFile;
            }
            return null;
        }
        if (this.completeProgramFile == null) {
            File file = this.programFileList.get(0);
            if (file.getName().endsWith(".abcd")) {
                try {
                    String fiacre = ABCDUtil.toFiacre(file);
                    String newName = file.getName().replaceAll("[.-]", "_");
                    File fiacreF = new File(file.getParentFile(), newName + ".fcr");
                    fiacreF.createNewFile();
                    BufferedWriter os = new BufferedWriter(new FileWriter(fiacreF));
                    os.write(fiacre);
                    os.close();
                    return fiacreF;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return this.programFileList.get(0);
        }
        return this.completeProgramFile;
    }

    public String getProgramSource() {
        return this.programSource;
    }

    public void setCCSLFile(File ccslFile) {
        this.ccslFile = ccslFile;
    }

    public boolean isNoConfs() {
        return this.noConfs;
    }

    public void setNoConfs(boolean noConfs) {
        this.noConfs = noConfs;
    }

    public boolean reloadFilesIfNeeded(boolean forceReload) {
        boolean reloaded = false;
        if (this.cdlFile != null && (forceReload || this.cdlFile.lastModified() != this.cdlFileModifiedDate)) {
            this.setCdlFile(this.cdlFile);
            reloaded = true;
            this.errorHandler.handleError(0, "CDL file reloaded.\n");
        }
        boolean modified = false;
        for (int i = 0; i < this.programFileList.size(); ++i) {
            File programFile = this.programFileList.get(i);
            long date = this.programFileModifiedDate.get(i);
            if (!forceReload && programFile.lastModified() == date) continue;
            modified = true;
        }
        if (modified) {
            this.refreshProgramSource();
            reloaded = true;
            this.errorHandler.handleError(0, "Program files reloaded.\n");
        }
        return reloaded;
    }

    public boolean isMoCCMLModel(File file) {
        return file.getName().endsWith(".graph.lts");
    }

    public boolean canVerify() {
        File file = this.getExplorableProgramFile();
        if (file == null) {
            return false;
        }
        if (this.isMoCCMLModel(file)) {
            return true;
        }
        if (!this.programSourceParsable) {
            return false;
        }
        return this.getCdlFile() == null || this.getCdlUnit() != null;
    }

    public void verify(final OBPController controller, final ActionMonitor monitor) {
        File file = this.getExplorableProgramFile();
        if (this.isMoCCMLModel(file)) {
            this.explore(controller, monitor);
            return;
        }
        if (!this.compiled) {
            controller.compileFiacre(file, (ActionMonitor)new ActionMonitor.Stub(){

                public void canceled() {
                    monitor.canceled();
                }

                public void done() {
                    OBPModel.this.compiled = true;
                    OBPModel.this.explore(controller, monitor);
                }
            });
        } else {
            this.explore(controller, monitor);
        }
    }

    private void explore(final OBPController controller, final ActionMonitor monitor) {
        this.cachedResultsString = null;
        ActionMonitor.Sub sub = new ActionMonitor.Sub(monitor, -1, -1){

            public void done() {
                while (controller.hasResult()) {
                    OBPModel.this.explorerResults.add(controller.popResult(ExplorerResult.class));
                }
                monitor.done();
            }

            public void canceled() {
                while (controller.hasResult() && controller.isResult(ExplorerResult.class)) {
                    OBPModel.this.explorerResults.add(controller.popResult(ExplorerResult.class));
                }
                monitor.canceled();
            }
        };
        this.explorerResults = new ArrayList<ExplorerResult>();
        File file = this.getExplorableProgramFile();
        if (this.isMoCCMLModel(file)) {
            controller.exploreMoCCML(file, this.saveConfigurationFile, (ActionMonitor)sub);
            return;
        }
        if (this.autoPartition) {
            controller.exploreAutoSplit(file, this.concreteContext, this.initialStep, this.splitStep, this.ccslFile, this.saveConfigurationFile, (ActionMonitor)sub);
        } else {
            controller.explore(file, this.concreteContext, this.ccslFile, this.saveConfigurationFile, (ActionMonitor)sub);
        }
    }

    public boolean isComputingCdlInformation() {
        return this.computingCdlInformation;
    }

    public void stopComputingCdlInformation() {
        if (this.computingCdlInformation && this.cdlInformationThread != null) {
            this.cdlInformationThread.interrupt();
        }
    }

    public void computeCdlInfo(final ActionMonitor monitor) {
        if (this.cdl != null && this.concreteContext != null) {
            this.cdlInformationUptodate = false;
            this.computingCdlInformation = true;
            final long startDate = System.nanoTime();
            this.cdlInformationThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        OBPModel.this.contextPathCount = ConcreteContextUtil.countPaths(OBPModel.this.concreteContext);
                        OBPModel.this.cdlInformationUptodate = true;
                        long endDate = System.nanoTime();
                        float delay = (float)(endDate - startDate) / 1000000.0f;
                        OBPModel.this.errorHandler.handleError(0, "Computed CDL informations in " + OBPModel.this.integerFormat.format(delay) + " ms.\n");
                        monitor.done();
                    }
                    catch (Throwable e) {
                        OBPModel.this.cdlInformationUptodate = false;
                        OBPModel.this.errorHandler.handleError(2, DiagnosticUtil.createMessage((Throwable)e) + "\n");
                        monitor.canceled();
                    }
                    finally {
                        OBPModel.this.computingCdlInformation = false;
                        OBPModel.this.cdlInformationThread = null;
                    }
                }
            });
            this.cdlInformationThread.start();
        } else {
            monitor.done();
        }
    }

    public String getCdlInfoDescription() {
        StringBuilder info = new StringBuilder();
        if (this.cdl == null || this.concreteContext == null) {
            info.append("No CDL loaded");
        } else {
            info.append("Complete concrete context contains ");
            info.append(this.integerFormat.format(this.concreteContext.getStateCount()));
            info.append(" st. and ");
            info.append(this.integerFormat.format(this.concreteContext.getTransitionCount()));
            info.append(" tr.\n");
            if (this.cdlInformationUptodate) {
                info.append("Counted ");
                info.append(this.integerFormat.format(this.contextPathCount));
                info.append(" paths in context.");
            } else {
                info.append("Click on 'refresh' to count paths.");
            }
        }
        return info.toString();
    }

    public boolean hasResults() {
        return this.explorerResults != null && this.explorerResults.size() > 0;
    }

    public List<ExplorerResult> getResults() {
        return this.explorerResults == null ? null : Collections.unmodifiableList(this.explorerResults);
    }

    public String getResultDescription() {
        if (this.cachedResultsString == null) {
            String header = this.resultDescriptionHeader();
            this.cachedResultsString = ExplorerResultUtil.toDescription(header, this.explorerResults);
        }
        return this.cachedResultsString;
    }

    private String resultDescriptionHeader() {
        StringBuilder header = new StringBuilder();
        header.append("--------------------Informations------------------");
        header.append("\n");
        header.append("Exploration: ");
        DateFormat format = SimpleDateFormat.getDateTimeInstance();
        header.append(format.format(new Date()));
        header.append("\n");
        if (this.getCdlFile() != null && this.getCdl() != null) {
            header.append("CDL '");
            header.append(this.cdl.getName());
            header.append("' ");
            header.append("in file: ");
            header.append(this.getCdlFile().getPath());
            header.append(".\n");
            if (this.getCdl().getPropertyCount() > 0) {
                header.append("Verified properties :");
                for (PropertyReference reference : this.getCdl().getPropertyList()) {
                    header.append(" '");
                    header.append(reference.getName());
                    header.append("'");
                }
                header.append(".\n");
            }
        }
        if (this.isAutoPartition()) {
            header.append("CDL has been split (initial: ");
            header.append(this.getInitialStep());
            header.append(", step: ");
            header.append(this.getSplitStep());
            header.append(").\n");
            header.append("\n");
        }
        header.append("Fiacre file names:\n");
        for (File file : this.getProgramFileList()) {
            header.append("- ");
            header.append(file.getPath());
            header.append(".\n");
        }
        return header.toString();
    }

    public boolean isSaveConfigurationFile() {
        return this.saveConfigurationFile;
    }

    public void setSaveConfigurationFile(boolean isSet) {
        this.saveConfigurationFile = isSet;
    }
}

