/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.fp;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import tlc2.output.MP;
import tlc2.tool.distributed.fp.FPSetManagerException;
import tlc2.tool.distributed.fp.FPSetRMI;
import tlc2.tool.distributed.fp.IFPSetManager;
import tlc2.util.BitVector;
import tlc2.util.LongVec;

public class NonDistributedFPSetManager
implements IFPSetManager {
    private final FPSetRMI fpSet;
    private final String hostname;

    public NonDistributedFPSetManager(FPSetRMI fpSet, String hostname) throws IOException {
        this.fpSet = fpSet;
        this.hostname = hostname;
    }

    @Override
    public void register(FPSetRMI fpSet, String hostname) throws FPSetManagerException {
        throw new UnsupportedOperationException("Not applicable for non-distributed FPSetManager");
    }

    @Override
    public int numOfServers() {
        return 1;
    }

    @Override
    public int numOfAliveServers() {
        return this.numOfServers();
    }

    public String getHostName() {
        return this.hostname;
    }

    @Override
    public boolean put(long fp) {
        try {
            return this.fpSet.put(fp);
        }
        catch (IOException e) {
            MP.printError(1000, e);
            return false;
        }
    }

    @Override
    public boolean contains(long fp) {
        try {
            return this.fpSet.contains(fp);
        }
        catch (IOException e) {
            MP.printError(1000, e);
            return false;
        }
    }

    @Override
    public int getFPSetIndex(long fp) {
        return 0;
    }

    @Override
    public BitVector[] putBlock(LongVec[] fps) {
        BitVector[] res = new BitVector[fps.length];
        for (int i = 0; i < fps.length; ++i) {
            LongVec longVec = fps[i];
            try {
                res[i] = this.fpSet.putBlock(longVec);
                continue;
            }
            catch (IOException e) {
                MP.printError(1000, e);
                res[i] = new BitVector(0);
            }
        }
        return res;
    }

    @Override
    public BitVector[] putBlock(LongVec[] fps, ExecutorService executorService) {
        return this.putBlock(fps);
    }

    @Override
    public BitVector[] containsBlock(LongVec[] fps) {
        BitVector[] res = new BitVector[fps.length];
        for (int i = 0; i < fps.length; ++i) {
            LongVec longVec = fps[i];
            try {
                res[i] = this.fpSet.containsBlock(longVec);
                continue;
            }
            catch (IOException e) {
                MP.printError(1000, e);
                res[i] = new BitVector(0);
            }
        }
        return res;
    }

    @Override
    public BitVector[] containsBlock(LongVec[] fps, ExecutorService executorService) {
        return this.containsBlock(fps);
    }

    @Override
    public double checkFPs() {
        try {
            return this.fpSet.checkFPs();
        }
        catch (IOException e) {
            MP.printError(1000, e);
            return -1.0;
        }
    }

    @Override
    public boolean checkInvariant() {
        try {
            return this.fpSet.checkInvariant();
        }
        catch (IOException e) {
            MP.printError(1000, e);
            return false;
        }
    }

    @Override
    public long size() {
        try {
            return this.fpSet.size();
        }
        catch (IOException e) {
            MP.printError(1000, e);
            return -1L;
        }
    }

    @Override
    public long getStatesSeen() {
        try {
            return this.fpSet.size();
        }
        catch (IOException e) {
            MP.printError(1000, e);
            return -1L;
        }
    }

    public long getMask() {
        return Long.MAX_VALUE;
    }

    @Override
    public void checkpoint(String fname) throws InterruptedException, IOException {
        this.fpSet.beginChkpt();
    }

    @Override
    public void commitChkpt() throws IOException {
        this.fpSet.commitChkpt();
    }

    @Override
    public void recover(String fname) throws InterruptedException, IOException {
        this.fpSet.recover();
    }

    @Override
    public void close(boolean cleanup) throws IOException {
        this.fpSet.close();
        this.fpSet.exit(cleanup);
    }
}

