/*
 * Decompiled with CFR 0.152.
 */
package spinja.store.hash;

import spinja.store.hash.JenkinsHash;

public abstract class HashAlgorithm {
    public static final HashAlgorithm getDefaultAlgorithm() {
        return new JenkinsHash();
    }

    public abstract int hash(byte[] var1, int var2);

    public abstract long hash(byte[] var1, long var2);

    public HashGenerator hash(final byte[] byArray) {
        return new HashGenerator(){
            private int value;
            private final int incr;
            {
                this.value = HashAlgorithm.this.hash(byArray, 0);
                this.incr = HashAlgorithm.this.hash(byArray, this.value) | 1;
            }

            @Override
            public int currentHash() {
                return this.value;
            }

            @Override
            public int nextHash() {
                this.value += this.incr;
                return this.value;
            }
        };
    }

    public LongHashGenerator bitstateHash(final byte[] byArray) {
        return new LongHashGenerator(){
            private long value;
            {
                this.value = HashAlgorithm.this.hash(byArray, 0L);
            }

            @Override
            public long currentHash() {
                return this.value;
            }

            @Override
            public long nextHash() {
                this.value = HashAlgorithm.this.hash(byArray, this.value);
                return this.value;
            }
        };
    }

    protected static final int rot(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    protected static final long rot(long l, int n) {
        return l << n | l >>> 64 - n;
    }

    public static interface LongHashGenerator {
        public long currentHash();

        public long nextHash();
    }

    public static interface HashGenerator {
        public int currentHash();

        public int nextHash();
    }
}

