@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  simulator startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and SIMULATOR_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-Dapple.laf.useScreenMenuBar=true"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\simulator-0.0.6.jar;%APP_HOME%\lib\plug-core-ui-0.0.6.jar;%APP_HOME%\lib\plug-runtime-buchikripke-0.0.6.jar;%APP_HOME%\lib\plug-runtime-buchi-0.0.6.jar;%APP_HOME%\lib\plug-runtime-lexplicit-0.0.6.jar;%APP_HOME%\lib\runtime-fiacre-0.0.6.jar;%APP_HOME%\lib\runtime-postmortem-obp-0.0.6.jar;%APP_HOME%\lib\plug-runtime-lspinja-0.0.6.jar;%APP_HOME%\lib\plug-runtime-composite-0.0.6.jar;%APP_HOME%\lib\plug-runtime-ltuml-0.0.6.jar;%APP_HOME%\lib\plug-runtime-remote-0.0.6.jar;%APP_HOME%\lib\plug-runtime-ltla-0.0.6.jar;%APP_HOME%\lib\plug-synchronization-0.0.6.jar;%APP_HOME%\lib\plug-pastfreeze-0.0.6.jar;%APP_HOME%\lib\plug-core-0.0.6.jar;%APP_HOME%\lib\LTL-0.0.6.jar;%APP_HOME%\lib\jackson-databind-2.7.2.jar;%APP_HOME%\lib\BuchiAutomata-0.0.6.jar;%APP_HOME%\lib\LPropositionalLogic-0.0.6.jar;%APP_HOME%\lib\antlr4-runtime-4.5.jar;%APP_HOME%\lib\ecj-4.4.1.jar;%APP_HOME%\lib\luaj-jse-3.0.1.jar;%APP_HOME%\lib\OBP-1.5.1-light.jar;%APP_HOME%\lib\basics-2.0.jar;%APP_HOME%\lib\beaver-rt-0.9.11.jar;%APP_HOME%\lib\java-cup-0.11a.jar;%APP_HOME%\lib\spinja-0.9.2.jar;%APP_HOME%\lib\antlr4-4.5.3.jar;%APP_HOME%\lib\tuml-interpreter-0.0.2.jar;%APP_HOME%\lib\org.eclipse.emf.common-2.11.0-v20150123-0347.jar;%APP_HOME%\lib\org.eclipse.emf.ecore-2.11.0-v20150123-0347.jar;%APP_HOME%\lib\org.eclipse.emf.ecore.xmi-2.11.0-v20150123-0347.jar;%APP_HOME%\lib\org.eclipse.emf.edit-2.11.0-v20150123-0357.jar;%APP_HOME%\lib\org.eclipse.uml2.common-2.0.1.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.uml2.types-2.0.0.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.uml2.uml-5.0.2.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.uml2.uml.profile.standard-1.0.0.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.uml2.uml.resources-5.0.2.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.xtend.standalone-2.4.3.jar;%APP_HOME%\lib\announce4j-master.jar;%APP_HOME%\lib\plug-utils-fx-0.0.6.jar;%APP_HOME%\lib\plug-utils-0.0.6.jar;%APP_HOME%\lib\ikonli-javafx-2.1.1.jar;%APP_HOME%\lib\ikonli-material-pack-2.1.1.jar;%APP_HOME%\lib\ikonli-typicons-pack-2.1.1.jar;%APP_HOME%\lib\richtextfx-0.9.0.jar;%APP_HOME%\lib\flowless-0.6.1.jar;%APP_HOME%\lib\controlsfx-8.40.14.jar;%APP_HOME%\lib\tla2tools-1.5.7.jar;%APP_HOME%\lib\LTL3BA-0.0.6.jar;%APP_HOME%\lib\jackson-annotations-2.7.0.jar;%APP_HOME%\lib\jackson-core-2.7.2.jar;%APP_HOME%\lib\javabdd-1.0b2.jar;%APP_HOME%\lib\org.abego.treelayout.core-1.0.1.jar;%APP_HOME%\lib\org.eclipse.xtend.lib-2.9.0.jar;%APP_HOME%\lib\org.eclipse.xtend.lib.macro-2.9.0.jar;%APP_HOME%\lib\org.eclipse.xtext.xbase.lib-2.9.0.jar;%APP_HOME%\lib\guava-14.0.1.jar;%APP_HOME%\lib\guice-3.0.jar;%APP_HOME%\lib\log4j-1.2.15.jar;%APP_HOME%\lib\org.eclipse.emf.mapping.ecore2xml-2.8.0-v20150123-0452.jar;%APP_HOME%\lib\java-petitparser-2.0.0.jar;%APP_HOME%\lib\ikonli-core-2.1.1.jar;%APP_HOME%\lib\undofx-2.0.0.jar;%APP_HOME%\lib\reactfx-2.0-M5.jar;%APP_HOME%\lib\wellbehavedfx-0.3.3.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\cglib-2.2.1-v20090111.jar;%APP_HOME%\lib\petitparser-json-2.0.0.jar;%APP_HOME%\lib\petitparser-smalltalk-2.0.0.jar;%APP_HOME%\lib\petitparser-xml-2.0.0.jar;%APP_HOME%\lib\petitparser-core-2.0.0.jar;%APP_HOME%\lib\asm-3.1.jar

@rem Execute simulator
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %SIMULATOR_OPTS%  -classpath "%CLASSPATH%" plug.ui2.simulation.ui.PlugSimulationUI %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable SIMULATOR_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%SIMULATOR_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
