/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.LinkedHashSet;
import java.util.Set;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.Commented;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Transition;
import obp.fiacre.model.WhileStmt;

public class CommentedUtil {
    public static boolean containsAnnotation(Commented commented, String annotation) {
        String search = "@" + annotation;
        for (String comment : commented.getCommentList()) {
            if (!comment.trim().equals(search)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> collectAllInformals(ProcessDecl process) {
        LinkedHashSet<String> informals = new LinkedHashSet<String>();
        for (Transition transition : process.getTransitionList()) {
            CommentedUtil.findAll(informals, transition.getAction());
        }
        return informals;
    }

    private static void findAll(Set<String> informals, Statement statement) {
        for (String comment : statement.getCommentList()) {
            if (!comment.startsWith("@")) continue;
            informals.add(comment.substring(1).trim());
        }
        if (statement instanceof CaseStmt) {
            for (Rule rule : ((CaseStmt)statement).getRuleList()) {
                CommentedUtil.findAll(informals, rule.getAction());
            }
        } else if (statement instanceof Foreach) {
            CommentedUtil.findAll(informals, ((Foreach)statement).getBody());
        } else if (statement instanceof IfStmt) {
            CommentedUtil.findAll(informals, ((IfStmt)statement).getThen());
            CommentedUtil.findAll(informals, ((IfStmt)statement).getElse());
        } else if (statement instanceof Seq) {
            for (Statement one : ((Seq)statement).getStatementList()) {
                CommentedUtil.findAll(informals, one);
            }
        } else if (statement instanceof Select) {
            for (Statement one : ((Select)statement).getStatementList()) {
                CommentedUtil.findAll(informals, one);
            }
        } else if (statement instanceof WhileStmt) {
            CommentedUtil.findAll(informals, ((WhileStmt)statement).getBody());
        }
    }

    public static String informalFromComment(String comment) {
        if (comment != null && comment.startsWith("@")) {
            return comment.substring(1).trim();
        }
        return null;
    }
}

