/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.Stack;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.Arg;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ChannelDecl;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.CondExp;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Element;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ExternalFunctionDecl;
import obp.fiacre.model.ExternalFunctionRef;
import obp.fiacre.model.Field;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.FiniteBound;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.FunctionDecl;
import obp.fiacre.model.FunctionRef;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.InfiniteBound;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.Instance;
import obp.fiacre.model.IntType;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.Interval;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.NonDeterministicAssignment;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Par;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PatternExp;
import obp.fiacre.model.PatternStmt;
import obp.fiacre.model.Priority;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Program;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Record;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.ReturnStmt;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Synchronization;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.Union;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;

public class ModelWalker
implements ModelVisitor {
    private final ModelVisitor delegate;
    private final Stack<Element> parentStack = new Stack();

    public ModelWalker(ModelVisitor delegate) {
        this.delegate = delegate;
    }

    public Stack<Element> getParentStack() {
        return this.parentStack;
    }

    @Override
    public void visitProgram(Program toVisit) {
        this.parentStack.push(toVisit);
        for (Declaration child : toVisit.getDeclarationList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getIs() != null) {
            toVisit.getIs().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitChannelDecl(ChannelDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getIs() != null) {
            toVisit.getIs().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitComponentDecl(ComponentDecl toVisit) {
        this.parentStack.push(toVisit);
        for (ArgumentVariable argumentVariable : toVisit.getArgList()) {
            argumentVariable.accept(this);
        }
        for (LocalVariable localVariable : toVisit.getVarList()) {
            localVariable.accept(this);
        }
        for (ParamPortDecl paramPortDecl : toVisit.getPortList()) {
            paramPortDecl.accept(this);
        }
        for (LocalPortDecl localPortDecl : toVisit.getLocalPortList()) {
            localPortDecl.accept(this);
        }
        if (toVisit.getInitAction() != null) {
            toVisit.getInitAction().accept(this);
        }
        if (toVisit.getBody() != null) {
            toVisit.getBody().accept(this);
        }
        for (Priority priority : toVisit.getPriorityList()) {
            priority.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        this.parentStack.push(toVisit);
        for (ArgumentVariable argumentVariable : toVisit.getArgList()) {
            argumentVariable.accept(this);
        }
        for (LocalVariable localVariable : toVisit.getVarList()) {
            localVariable.accept(this);
        }
        for (ParamPortDecl paramPortDecl : toVisit.getPortList()) {
            paramPortDecl.accept(this);
        }
        for (LocalPortDecl localPortDecl : toVisit.getLocalPortList()) {
            localPortDecl.accept(this);
        }
        if (toVisit.getInitAction() != null) {
            toVisit.getInitAction().accept(this);
        }
        for (State state : toVisit.getStateList()) {
            state.accept(this);
        }
        for (Transition transition : toVisit.getTransitionList()) {
            transition.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitFunctionDecl(FunctionDecl toVisit) {
        this.parentStack.push(toVisit);
        for (ArgumentVariable argumentVariable : toVisit.getArgList()) {
            argumentVariable.accept(this);
        }
        for (LocalVariable localVariable : toVisit.getVarList()) {
            localVariable.accept(this);
        }
        if (toVisit.getReturnType() != null) {
            toVisit.getReturnType().accept(this);
        }
        if (toVisit.getBody() != null) {
            toVisit.getBody().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitExternalFunctionDecl(ExternalFunctionDecl toVisit) {
        this.parentStack.push(toVisit);
        for (ExternalArgument child : toVisit.getArgList()) {
            child.accept(this);
        }
        if (toVisit.getReturnType() != null) {
            toVisit.getReturnType().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitExternalArgument(ExternalArgument toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitArgumentVariable(ArgumentVariable toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitLocalVariable(LocalVariable toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getInitializer() != null) {
            toVisit.getInitializer().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitPar(Par toVisit) {
        this.parentStack.push(toVisit);
        for (InterfacedComp child : toVisit.getArgList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInstance(Instance toVisit) {
        this.parentStack.push(toVisit);
        for (Arg child : toVisit.getArgList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInterfacedComp(InterfacedComp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getComposition() != null) {
            toVisit.getComposition().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitState(State toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitTransition(Transition toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getAction() != null) {
            toVisit.getAction().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitNullStmt(NullStmt toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getCondition() != null) {
            toVisit.getCondition().accept(this);
        }
        if (toVisit.getBody() != null) {
            toVisit.getBody().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getCondition() != null) {
            toVisit.getCondition().accept(this);
        }
        if (toVisit.getThen() != null) {
            toVisit.getThen().accept(this);
        }
        if (toVisit.getElse() != null) {
            toVisit.getElse().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSelect(Select toVisit) {
        this.parentStack.push(toVisit);
        for (Statement child : toVisit.getStatementList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitTo(To toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitWait(Wait toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getMini() != null) {
            toVisit.getMini().accept(this);
        }
        if (toVisit.getMaxi() != null) {
            toVisit.getMaxi().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitReturnStmt(ReturnStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitDeterministicAssignment(DeterministicAssignment toVisit) {
        this.parentStack.push(toVisit);
        for (SingleAssignment child : toVisit.getAssignmentList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitNonDeterministicAssignment(NonDeterministicAssignment toVisit) {
        this.parentStack.push(toVisit);
        for (Pattern child : toVisit.getLhsList()) {
            child.accept(this);
        }
        if (toVisit.getCondition() != null) {
            toVisit.getCondition().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSingleAssignment(SingleAssignment toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getLhs() != null) {
            toVisit.getLhs().accept(this);
        }
        if (toVisit.getRhs() != null) {
            toVisit.getRhs().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitUnExp(UnExp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExp() != null) {
            toVisit.getExp().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitBinExp(BinExp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getRight() != null) {
            toVisit.getRight().accept(this);
        }
        if (toVisit.getLeft() != null) {
            toVisit.getLeft().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitFunctionRef(FunctionRef toVisit) {
        this.parentStack.push(toVisit);
        for (Exp child : toVisit.getParamList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitExternalFunctionRef(ExternalFunctionRef toVisit) {
        this.parentStack.push(toVisit);
        for (Exp child : toVisit.getParamList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitNatLiteral(NatLiteral toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitBoolLiteral(BoolLiteral toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitVarRef(VarRef toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitArrayElem(ArrayElem toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getArray() != null) {
            toVisit.getArray().accept(this);
        }
        if (toVisit.getIndex() != null) {
            toVisit.getIndex().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitRecordElem(RecordElem toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getRecord() != null) {
            toVisit.getRecord().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInlineQueue(InlineQueue toVisit) {
        this.parentStack.push(toVisit);
        for (Exp child : toVisit.getElemList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getMini() != null) {
            toVisit.getMini().accept(this);
        }
        if (toVisit.getMaxi() != null) {
            toVisit.getMaxi().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitRecord(Record toVisit) {
        this.parentStack.push(toVisit);
        for (Field child : toVisit.getFieldList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitField(Field toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getType() != null) {
            toVisit.getType().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitArray(Array toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getType() != null) {
            toVisit.getType().accept(this);
        }
        if (toVisit.getSize() != null) {
            toVisit.getSize().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getType() != null) {
            toVisit.getType().accept(this);
        }
        if (toVisit.getSize() != null) {
            toVisit.getSize().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitProfile(Profile toVisit) {
        this.parentStack.push(toVisit);
        for (Type child : toVisit.getTypeList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInlineArray(InlineArray toVisit) {
        this.parentStack.push(toVisit);
        for (Exp child : toVisit.getElemList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInlineRecord(InlineRecord toVisit) {
        this.parentStack.push(toVisit);
        for (ValuedField child : toVisit.getValueList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitValuedField(ValuedField toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getValue() != null) {
            toVisit.getValue().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSynchronization(Synchronization toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitReception(Reception toVisit) {
        this.parentStack.push(toVisit);
        for (Pattern child : toVisit.getPatternList()) {
            child.accept(this);
        }
        if (toVisit.getWhere() != null) {
            toVisit.getWhere().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitEmission(Emission toVisit) {
        this.parentStack.push(toVisit);
        for (Exp child : toVisit.getArgList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSeq(Seq toVisit) {
        this.parentStack.push(toVisit);
        for (Statement child : toVisit.getStatementList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitLocalPortDecl(LocalPortDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getChannel() != null) {
            toVisit.getChannel().accept(this);
        }
        if (toVisit.getMini() != null) {
            toVisit.getMini().accept(this);
        }
        if (toVisit.getMaxi() != null) {
            toVisit.getMaxi().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitParamPortDecl(ParamPortDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getChannel() != null) {
            toVisit.getChannel().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitPriority(Priority toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitConstrExp(ConstrExp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getArg() != null) {
            toVisit.getArg().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitUnion(Union toVisit) {
        this.parentStack.push(toVisit);
        for (Constr child : toVisit.getConstrList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitConstrPattern(ConstrPattern toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getArg() != null) {
            toVisit.getArg().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitArrayPattern(ArrayPattern toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getIndex() != null) {
            toVisit.getIndex().accept(this);
        }
        if (toVisit.getArray() != null) {
            toVisit.getArray().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitFieldPattern(FieldPattern toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getRecord() != null) {
            toVisit.getRecord().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitAnyPattern(AnyPattern toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        this.parentStack.push(toVisit);
        for (Rule child : toVisit.getRuleList()) {
            child.accept(this);
        }
        if (toVisit.getExp() != null) {
            toVisit.getExp().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitRule(Rule toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getLhs() != null) {
            toVisit.getLhs().accept(this);
        }
        if (toVisit.getAction() != null) {
            toVisit.getAction().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitRefArg(RefArg toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitConstantDecl(ConstantDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getType() != null) {
            toVisit.getType().accept(this);
        }
        if (toVisit.getValue() != null) {
            toVisit.getValue().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitConstantRef(ConstantRef toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitConstr(Constr toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getType() != null) {
            toVisit.getType().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitFiniteBound(FiniteBound toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInfiniteBound(InfiniteBound toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitCondExp(CondExp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getCond() != null) {
            toVisit.getCond().accept(this);
        }
        if (toVisit.getIff() != null) {
            toVisit.getIff().accept(this);
        }
        if (toVisit.getIft() != null) {
            toVisit.getIft().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitForeach(Foreach toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getBody() != null) {
            toVisit.getBody().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitPatternExp(PatternExp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExp() != null) {
            toVisit.getExp().accept(this);
        }
        if (toVisit.getPattern() != null) {
            toVisit.getPattern().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitPatternStmt(PatternStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExp() != null) {
            toVisit.getExp().accept(this);
        }
        if (toVisit.getPattern() != null) {
            toVisit.getPattern().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }
}

