/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.evaluator;

import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.evaluator.Evaluator;

public class ComposedEvaluator
extends Evaluator {
    private final Type type;
    private final Evaluator[] children;

    public ComposedEvaluator(ExplorationContext context, Type type, Evaluator[] children) {
        super(context);
        this.type = type;
        this.children = children;
        if (type == Type.Not && children.length != 1) {
            throw new IllegalArgumentException("Not matcher must have one child.");
        }
    }

    @Override
    public Object evaluate(Object argument) {
        Boolean current = null;
        switch (this.type) {
            case Not: {
                return Boolean.FALSE.equals(this.children[0].evaluate(argument));
            }
            case And: {
                for (Evaluator child : this.children) {
                    if (!Boolean.FALSE.equals(child.evaluate(argument))) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case Or: {
                for (Evaluator child : this.children) {
                    if (!Boolean.TRUE.equals(child.evaluate(argument))) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case Implication: {
                for (Evaluator child : this.children) {
                    current = current == null ? (Boolean)child.evaluate(argument) : Boolean.valueOf(current == false || (Boolean)child.evaluate(argument) != false);
                }
                return current;
            }
            case Equivalence: {
                for (Evaluator child : this.children) {
                    current = current == null ? (Boolean)child.evaluate(argument) : Boolean.valueOf(!(current ^ (Boolean)child.evaluate(argument)));
                }
                return current;
            }
        }
        return Boolean.FALSE;
    }

    public static enum Type {
        And,
        Or,
        Not,
        Implication,
        Equivalence;

    }
}

