/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.variable;

import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.variable.VariableType;
import spinja.util.StringWriter;

public class Variable {
    private final String name;
    private final int arraySize;
    private Expression initExpr;
    private VariableType type;
    private boolean isRead;
    private boolean isWritten;

    public Variable(VariableType variableType, String string, int n) {
        this.name = string;
        this.arraySize = n;
        this.type = variableType;
        this.isRead = false;
        this.isWritten = false;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public void setType(VariableType variableType) {
        this.type = variableType;
    }

    public Expression getInitExpr() {
        return this.initExpr;
    }

    public void printInitExpr(StringWriter stringWriter) throws ParseException {
        if (this.arraySize > 1) {
            stringWriter.appendLine(this.name, " = new ", this.type.getJavaName(), "[", this.arraySize, "];");
            if (this.initExpr != null) {
                stringWriter.appendLine("for(int i = 0; i < ", this.arraySize, "; i++) {");
                stringWriter.indent();
                stringWriter.appendLine(this.name, "[i] = ", this.initExpr.getIntExpression(), ";");
                stringWriter.outdent();
                stringWriter.appendLine("}");
            }
        } else if (this.initExpr != null) {
            stringWriter.appendLine(this.name, " = ", this.initExpr.getIntExpression(), ";");
        }
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public boolean isWritten() {
        return this.isWritten;
    }

    public void setInitExpr(Expression expression) throws ParseException {
        if (!this.type.canConvert(expression.getResultType())) {
            throw new ParseException("Can not convert initializing expression to desired type");
        }
        this.initExpr = expression;
    }

    public void setRead(boolean bl) {
        this.isRead = bl;
    }

    public void setWritten(boolean bl) {
        this.isWritten = bl;
    }

    public String toString() {
        return this.getName();
    }
}

