/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.variable;

import java.util.ArrayList;
import java.util.List;
import spinja.promela.compiler.variable.Variable;
import spinja.promela.compiler.variable.VariableStore;
import spinja.promela.compiler.variable.VariableType;
import spinja.util.StringWriter;

public class ChannelType
extends VariableType {
    public static final VariableType UNASSIGNED_CHANNEL = new ChannelType(-1, -1);
    public static boolean rendezvousUsed = false;
    private final int bufferSize;
    private final VariableStore vars = new VariableStore();
    private final List<VariableType> types = new ArrayList<VariableType>();
    private final int id;

    public static boolean isRendezvousUsed() {
        return rendezvousUsed;
    }

    public ChannelType(int n, int n2) {
        super("chan", "int", 8);
        this.id = n;
        this.bufferSize = n2;
    }

    private void generateStorableMethods(StringWriter stringWriter) {
        stringWriter.appendLine("public void encode(DataWriter _writer) {");
        stringWriter.indent();
        stringWriter.appendLine("_writer.writeByte(", this.id, ");");
        if (this.bufferSize > 0) {
            stringWriter.appendLine("_writer.writeByte(filled);");
            stringWriter.appendLine("for(int i = 0; i < filled; i++) {");
            stringWriter.indent();
            this.vars.printEncode(stringWriter);
            stringWriter.outdent();
            stringWriter.appendLine("}");
        }
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("public int getSize() {");
        stringWriter.indent();
        if (this.bufferSize > 0) {
            stringWriter.appendLine("return 2 + filled * ", this.vars.getBufferSize(), ";");
        } else {
            stringWriter.appendLine("return 1;");
        }
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("public boolean decode(DataReader _reader) {");
        stringWriter.indent();
        stringWriter.appendLine("if(_reader.readByte() != ", this.id, ") return false;");
        if (this.bufferSize > 0) {
            stringWriter.appendLine("filled = _reader.readByte();");
            stringWriter.appendLine("first = 0;");
            stringWriter.appendLine("for(int i = 0; i < filled; i++) {");
            stringWriter.indent();
            this.vars.printDecode(stringWriter);
            stringWriter.outdent();
            stringWriter.appendLine("}");
        }
        stringWriter.appendLine("return true;");
        stringWriter.outdent();
        stringWriter.appendLine("}");
    }

    @Override
    public boolean canConvert(VariableType variableType) {
        return variableType instanceof ChannelType;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void generateClass(StringWriter stringWriter) {
        stringWriter.appendLine("public static class Channel", this.id, " extends Channel {");
        stringWriter.indent();
        stringWriter.appendLine("public Channel", this.id, "() {");
        stringWriter.indent();
        stringWriter.appendPrefix().append("super(new int[] {");
        for (VariableType variableType : this.types) {
            if (variableType.getMask() == null) {
                stringWriter.append("0xffffffff");
            } else {
                stringWriter.append(variableType.getMask());
            }
            stringWriter.append(", ");
        }
        stringWriter.setLength(stringWriter.length() - 2);
        stringWriter.append("}, ").append(this.bufferSize).append(");").appendPostfix();
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
        this.generateStorableMethods(stringWriter);
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void addType(VariableType variableType) {
        Variable variable = new Variable(variableType, "buffer[(i+first)%buffer.length][" + this.types.size() + "]", 1);
        variable.setRead(true);
        variable.setWritten(true);
        this.vars.addVariable(variable);
        this.types.add(variableType);
    }
}

