/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.automaton;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.automaton.ActionTransition;
import spinja.promela.compiler.automaton.Automaton;
import spinja.promela.compiler.automaton.EndTransition;
import spinja.promela.compiler.automaton.NeverEndTransition;
import spinja.promela.compiler.automaton.Transition;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class State {
    private boolean inAtomic;
    private int stateId;
    private final Automaton automaton;
    private final List<Transition> out;
    private final List<Transition> in;
    private final List<String> labels;
    public final Iterable<Transition> input = new Iterable<Transition>(){

        @Override
        public Iterator<Transition> iterator() {
            return new Iterator<Transition>(){
                private int index = 0;
                private int size;
                {
                    this.size = State.this.in.size();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.size;
                }

                @Override
                public Transition next() {
                    return (Transition)State.this.in.get(this.index++);
                }

                @Override
                public void remove() {
                    throw new NotImplementedException();
                }
            };
        }
    };
    public final Iterable<Transition> output = new Iterable<Transition>(){

        @Override
        public Iterator<Transition> iterator() {
            return new Iterator<Transition>(){
                private int index = 0;
                private int size;
                {
                    this.size = State.this.out.size();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.size;
                }

                @Override
                public Transition next() {
                    return (Transition)State.this.out.get(this.index++);
                }

                @Override
                public void remove() {
                    throw new NotImplementedException();
                }
            };
        }
    };

    public State(Automaton automaton, boolean bl) {
        this.automaton = automaton;
        this.inAtomic = bl;
        this.stateId = StateIdCounter.nextId();
        this.out = new ArrayList<Transition>();
        this.in = new ArrayList<Transition>();
        this.labels = new ArrayList<String>();
    }

    public void addLabel(String string) {
        this.labels.add(string);
    }

    void addOut(Transition transition) {
        this.out.add(transition);
    }

    void addOut(Transition transition, Transition transition2) {
        int n = this.out.indexOf(transition2);
        this.out.add(n + 1, transition);
    }

    void addIn(Transition transition) {
        this.in.add(transition);
    }

    void removeOut(Transition transition) {
        this.out.remove(transition);
    }

    void removeIn(Transition transition) {
        this.in.remove(transition);
        if (this.in.isEmpty()) {
            this.delete();
        }
    }

    public void delete() {
        while (!this.in.isEmpty()) {
            this.in.get(0).delete();
        }
        while (!this.out.isEmpty()) {
            this.out.get(0).delete();
        }
    }

    public boolean isEndingState() {
        for (Transition transition : this.out) {
            if (!(transition instanceof EndTransition) && !(transition instanceof NeverEndTransition)) continue;
            return true;
        }
        return this.hasLabelPrefix("end");
    }

    public boolean isAcceptState() {
        return this.hasLabelPrefix("accept");
    }

    public boolean isProgressState() {
        return this.hasLabelPrefix("progress");
    }

    public Transition getOut(int n) {
        return this.out.get(n);
    }

    public Transition getIn(int n) {
        return this.in.get(n);
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int n) {
        this.stateId = n;
    }

    public boolean hasLabelPrefix(String string) {
        for (String string2 : this.labels) {
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isInAtomic() {
        return this.inAtomic;
    }

    public void setInAtomic(boolean bl) {
        this.inAtomic = bl;
    }

    public boolean isLocal() {
        for (Transition transition : this.out) {
            if (transition.isLocal()) continue;
            return false;
        }
        return true;
    }

    public void merge(State state) {
        for (Transition transition : state.in) {
            transition.setTo(this);
            this.in.add(transition);
        }
        state.in.clear();
        for (Transition transition : state.out) {
            transition.setFrom(this);
            this.out.add(transition);
        }
        state.out.clear();
        if (this.automaton.getStartState() == state) {
            this.automaton.setStartState(this);
        }
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public int sizeIn() {
        return this.in.size();
    }

    public int sizeOut() {
        return this.out.size();
    }

    public String toString() {
        return (this.inAtomic ? "Atomic " : "") + "State " + this.stateId + " (OUT: " + this.out + ")";
    }

    public Transition newTransition(State state) {
        ActionTransition actionTransition = new ActionTransition(this, state);
        return actionTransition;
    }

    public Transition newTransition(Action action, State state) {
        ActionTransition actionTransition = new ActionTransition(this, state);
        ((Transition)actionTransition).addAction(action);
        return actionTransition;
    }

    private static class StateIdCounter {
        private static int id = 0;

        private StateIdCounter() {
        }

        private static synchronized int nextId() {
            return id++;
        }
    }
}

