/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.model;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;

public abstract class ChangeMark {
    protected final long timestamp;

    public static ChangeMark Operation(long timestamp) {
        return new OperationChangeMark(timestamp);
    }

    protected ChangeMark(long timestamp) {
        this.timestamp = timestamp;
    }

    public abstract void undo();

    public long getTimestamp() {
        return this.timestamp;
    }

    public abstract String toString();

    public boolean isOperationMark() {
        return false;
    }

    protected Method getMethod(Class<?> receiverClass, String name, Class<?> ... parameterTypes) throws SecurityException {
        AccessibleObject method = null;
        for (Method oneMethod : receiverClass.getMethods()) {
            if (!name.equals(oneMethod.getName())) continue;
            if (parameterTypes != null && parameterTypes.length == oneMethod.getParameterTypes().length) {
                boolean ok = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i] == null || oneMethod.getParameterTypes()[i].isAssignableFrom(parameterTypes[i])) continue;
                    ok = false;
                }
                if (!ok) continue;
                method = oneMethod;
                break;
            }
            if (oneMethod.getParameterTypes().length != 0) continue;
            method = oneMethod;
            break;
        }
        if (method != null && !method.isAccessible()) {
            ((Method)method).setAccessible(true);
        }
        return method;
    }

    private static class OperationChangeMark
    extends ChangeMark {
        protected OperationChangeMark(long timestamp) {
            super(timestamp);
        }

        @Override
        public void undo() {
        }

        @Override
        public String toString() {
            return "T" + this.getTimestamp();
        }

        @Override
        public boolean isOperationMark() {
            return true;
        }
    }
}

