/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xid.basics.error.DiagnosticUtil;

public abstract class AbstractCloner {
    private final Stack<Object> objectStack = new Stack();
    private final Map<Object, Object> clonedMap = new HashMap<Object, Object>();
    private final Map<Object, List<PendingReference>> pendingReferenceMap = new HashMap<Object, List<PendingReference>>();
    private final Map<String, Method> referenceMethodCacheMap = new HashMap<String, Method>();

    public int stackSize() {
        return this.objectStack.size();
    }

    public <T> T peekObject(Class<T> type) {
        Object node = this.objectStack.peek();
        return type.cast(node);
    }

    public <T> List<T> popObjectTo(int expectedSize, Class<T> type) {
        int currentSize = this.stackSize();
        int delta = currentSize - expectedSize;
        if (delta < 0) {
            return Collections.emptyList();
        }
        if (delta == 1) {
            return Collections.singletonList(this.popObject(type));
        }
        ArrayList<T> result = new ArrayList<T>(delta);
        for (int i = 0; i < delta; ++i) {
            result.add(this.popObject(type));
        }
        Collections.reverse(result);
        return result;
    }

    public <T> T popObject(Class<T> type) {
        Object node = this.objectStack.pop();
        return type.cast(node);
    }

    public void pushObject(Object node) {
        this.objectStack.push(node);
    }

    protected void registerClone(Object original, Object cloned) {
        this.clonedMap.put(original, cloned);
        List<PendingReference> toResolveList = this.pendingReferenceMap.get(original);
        if (toResolveList != null) {
            for (PendingReference pending : toResolveList) {
                try {
                    pending.method.invoke(pending.receiver, cloned);
                }
                catch (Exception e) {
                    String message = DiagnosticUtil.createMessage(e);
                    throw new IllegalArgumentException(message);
                }
            }
        }
    }

    protected boolean hasClone(Object original) {
        return this.clonedMap.containsKey(original);
    }

    protected Object getClone(Object original) {
        return this.clonedMap.get(original);
    }

    protected Object removeClone(Object original) {
        return this.clonedMap.remove(original);
    }

    protected void registerReference(Object receiver, String name, boolean many, Object original) {
        Object cloned;
        if (original == null) {
            return;
        }
        String prefix = many ? "add" : "set";
        String methodName = prefix + AbstractCloner.upcaseFirstCharacter(name);
        Class<?> klazz = receiver.getClass();
        String methodKey = klazz.getCanonicalName() + "#" + methodName;
        Method method = this.referenceMethodCacheMap.get(methodKey);
        if (method == null) {
            for (Method oneMethod : klazz.getMethods()) {
                if (!methodName.equals(oneMethod.getName()) || oneMethod.getParameterTypes().length != 1) continue;
                method = oneMethod;
                break;
            }
            if (method == null) {
                throw new IllegalArgumentException("Method '" + methodName + "' not found on class '" + klazz.getSimpleName() + "'.");
            }
            this.referenceMethodCacheMap.put(methodKey, method);
        }
        Object referenced = (cloned = this.clonedMap.get(original)) == null ? original : cloned;
        try {
            method.invoke(receiver, referenced);
        }
        catch (Exception e) {
            String message = DiagnosticUtil.createMessage(e);
            throw new IllegalArgumentException(message);
        }
        if (cloned == null) {
            this.registerPendingReference(original, receiver, method);
        }
    }

    private void registerPendingReference(Object original, Object receiver, Method method) {
        List<PendingReference> toResolveList = this.pendingReferenceMap.get(original);
        if (toResolveList == null) {
            toResolveList = new ArrayList<PendingReference>();
            this.pendingReferenceMap.put(original, toResolveList);
        }
        toResolveList.add(new PendingReference(receiver, method));
    }

    protected static String upcaseFirstCharacter(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 1) {
            return value.toUpperCase();
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private class PendingReference {
        private final Object receiver;
        private final Method method;

        public PendingReference(Object receiver, Method method) {
            this.receiver = receiver;
            this.method = method;
        }
    }
}

