/*
 * Decompiled with CFR 0.152.
 */
package plug.core.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import plug.core.execution.ExecutionDescription;

public class ExecutionModuleRegistry {
    private final Map<String, ExecutionDescription> nameMap = new LinkedHashMap<String, ExecutionDescription>();
    private static ExecutionModuleRegistry instance = null;

    private ExecutionModuleRegistry() {
    }

    public ExecutionDescription getModuleByName(String name) {
        return this.nameMap.get(name);
    }

    public Collection<ExecutionDescription> getModules() {
        return Collections.unmodifiableCollection(this.nameMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutionModuleRegistry getInstance() {
        if (instance != null) return instance;
        Class<ExecutionModuleRegistry> clazz = ExecutionModuleRegistry.class;
        synchronized (ExecutionModuleRegistry.class) {
            if (instance != null) return instance;
            instance = new ExecutionModuleRegistry();
            for (ExecutionDescription ilm : ServiceLoader.load(ExecutionDescription.class)) {
                ExecutionModuleRegistry.instance.nameMap.put(ilm.getName(), ilm);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

