/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.execution_units;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.FileChooser;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.ILanguagePlugin;
import plug.core.RuntimeDescription;
import plug.core.execution.ControllerProviderFunction;
import plug.core.execution.Execution;
import plug.core.fx.IAppContext;
import plug.core.fx.verification.ErrorsView;
import plug.core.registry.LanguageModuleRegistry;
import plug.core.ui.common.GPSL2Execution;
import plug.ui2.execution_units.ExecutionListCell2;

public class ExecutionListView
extends SplitPane {
    ObjectProperty<Path> modelPathProperty;
    ObjectProperty<Path> propertiesPathProperty;
    ObservableList<Execution> executionUnits = FXCollections.observableArrayList();
    protected final ObservableList<Throwable> errors = FXCollections.observableArrayList();

    public ExecutionListView(ObjectProperty<Path> modelPath, ObjectProperty<Path> propertiesPath, BooleanProperty modelChanged, BooleanProperty propertiesChanged, IAppContext appContext) {
        this.modelPathProperty = modelPath;
        this.propertiesPathProperty = propertiesPath;
        ListView executionUnitListView = new ListView();
        executionUnitListView.setCellFactory(list -> new ExecutionListCell2(appContext, this::errorHandler));
        Button runAll = new Button(null, (Node)new FontIcon("gmi-fast-forward"));
        runAll.setOnAction(ae -> executionUnitListView.getItems().forEach(e -> Platform.runLater(() -> {
            if (e.status == Execution.Status.CREATED) {
                e.initialize();
            }
            if (e.status != Execution.Status.INITIALIZED) {
                e.reset();
                e.initialize();
            }
            e.run();
            executionUnitListView.refresh();
        })));
        Button exportCSV = new Button(null, (Node)new FontIcon("gmi-file-download"));
        exportCSV.setOnAction(ae -> this.saveCSV((ObservableList<Execution>)executionUnitListView.getItems()));
        FlowPane menuFlowPane = new FlowPane();
        menuFlowPane.getChildren().addAll((Object[])new Node[]{runAll, exportCSV});
        BorderPane topPane = new BorderPane();
        topPane.setTop((Node)menuFlowPane);
        topPane.setCenter((Node)executionUnitListView);
        this.getItems().add((Object)topPane);
        ErrorsView errorsView = new ErrorsView(appContext, this.errors);
        this.setOrientation(Orientation.VERTICAL);
        this.setDividerPosition(0, 0.7);
        this.getItems().add((Object)errorsView);
        executionUnitListView.setItems(this.executionUnits);
        executionUnitListView.itemsProperty().bind((ObservableValue)Bindings.createObjectBinding(this::createExecutionsCallback, (Observable[])new Observable[]{modelPath, propertiesPath, modelChanged, propertiesChanged}));
    }

    void errorHandler(Execution execution) {
        Throwable exception = execution.getException();
        this.addError(exception);
    }

    ObservableList<Execution> createExecutionsCallback() {
        this.errors.clear();
        for (Execution execution : this.executionUnits) {
            execution.stop();
        }
        Path modelPath = (Path)this.modelPathProperty.get();
        if (modelPath == null) {
            return FXCollections.emptyObservableList();
        }
        ILanguagePlugin languagePlugin = LanguageModuleRegistry.getInstance().getModuleByExtension(modelPath);
        if (languagePlugin == null) {
            return FXCollections.emptyObservableList();
        }
        ObservableList executions = FXCollections.observableArrayList();
        try {
            for (Map.Entry executionModule : languagePlugin.executions().entrySet()) {
                Execution execution = new Execution((String)executionModule.getKey(), modelPath, languagePlugin, (ControllerProviderFunction)executionModule.getValue());
                executions.add((Object)execution);
            }
            Path propertiesPath = (Path)this.propertiesPathProperty.get();
            if (propertiesPath == null) {
                return executions;
            }
            RuntimeDescription modelDescription = new RuntimeDescription(modelPath);
            executions.addAll(new GPSL2Execution().executionsNEW(propertiesPath, modelDescription));
        }
        catch (Throwable e) {
            this.addError(e);
        }
        return executions;
    }

    void saveCSV(ObservableList<Execution> executions) {
        if (executions == null || executions.isEmpty()) {
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV File", new String[]{"*.csv"}));
        File file = chooser.showSaveDialog(this.getScene().getWindow());
        if (file == null) {
            return;
        }
        try {
            Files.write(file.toPath(), this.toCSV(executions).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String toCSV(ObservableList<Execution> executions) {
        ArrayList<String[]> table = new ArrayList<String[]>();
        String[] header = new String[]{"name", "configurations", "transitions", "loading", "elapsed", "status", "verification", "result"};
        table.add(header);
        for (Execution execution : executions) {
            table.add(this.executionCSV(execution));
        }
        return table.stream().map(line -> String.join((CharSequence)"; ", line) + "\n").reduce(String::concat).get();
    }

    String[] executionCSV(Execution execution) {
        String[] result = new String[]{execution.getName(), String.valueOf(execution.configurationCount()), String.valueOf(execution.transitionCount()), String.valueOf(execution.getLoadingTime()), String.valueOf(execution.getElapsedTime()), String.valueOf(execution.status()), String.valueOf(execution.verificationStatus()), String.valueOf(execution.resultStatus())};
        return result;
    }

    public void addError(Throwable e) {
        Throwable root = e;
        while (root.getCause() != null && (root = root.getCause()) != null) {
        }
        for (Throwable error : this.errors) {
            if (error.getClass() != root.getClass() || !Objects.equals(error.getMessage(), root.getMessage())) continue;
            return;
        }
        this.errors.add((Object)root);
    }
}

