/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.fireables;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.StackPane;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.IFiredTransition;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.ui2.simulation.fireables.FireableTransitionCell;
import plug.utils.ui.fx.GuiFxUtils;

public class FireableTransitionsView<C, T>
extends StackPane {
    private final ObjectProperty<ITransitionRelation<C, T>> transitionRelationProperty;
    private final ObjectProperty<IFiredTransition<C, ?>> outFiredTransition;
    protected final Random rnd = new Random();
    ObjectProperty<C> currentConfiguration;
    protected ListProperty<T> fireableTransitions = new SimpleListProperty();
    protected final ListView<T> listView;

    public FireableTransitionsView(ObjectProperty<C> inCurrentConfiguration, ObjectProperty<ITransitionRelation<C, T>> inTransitionRelationProperty, ObjectProperty<IRuntimeView<C, T>> inRuntimeViewProperty, ObjectProperty<IFiredTransition<C, ?>> outFiredTransition) {
        this.currentConfiguration = inCurrentConfiguration;
        this.transitionRelationProperty = inTransitionRelationProperty;
        this.outFiredTransition = outFiredTransition;
        this.setBackground(Background.EMPTY);
        this.fireableTransitions.bind((ObservableValue)Bindings.createObjectBinding(this::fireableTransitionsFromCallback, (Observable[])new Observable[]{this.currentConfiguration}));
        Button stepRandomButton = new Button("", (Node)new FontIcon("typ-arrow-shuffle:20:darkgreen"));
        stepRandomButton.setPickOnBounds(false);
        stepRandomButton.setId("fireRandom");
        stepRandomButton.setTooltip(new Tooltip("Fire Random Transition"));
        GuiFxUtils.addButtonEffects((Node)stepRandomButton);
        stepRandomButton.setOnAction(event -> {
            int numberOfFireables = this.fireableTransitions.size();
            if (numberOfFireables < 1) {
                return;
            }
            int index = this.rnd.nextInt(numberOfFireables);
            this.fireCallback(this.fireableTransitions.get(index));
        });
        this.fireableTransitions.addListener((a, o, n) -> {
            if (n == null || n.isEmpty()) {
                stepRandomButton.setDisable(true);
            } else {
                stepRandomButton.setDisable(false);
            }
        });
        this.listView = new ListView(this.fireableTransitions);
        this.listView.setCellFactory(v -> new FireableTransitionCell(this::fireCallback, inRuntimeViewProperty));
        this.listView.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.fireCallback(this.listView.getSelectionModel().getSelectedItem());
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.listView, stepRandomButton});
        FireableTransitionsView.setAlignment((Node)stepRandomButton, (Pos)Pos.CENTER_RIGHT);
    }

    private ObservableList<T> fireableTransitionsFromCallback() {
        ITransitionRelation transitionRelation = (ITransitionRelation)this.transitionRelationProperty.get();
        Object source = this.currentConfiguration.get();
        if (source == null) {
            return FXCollections.emptyObservableList();
        }
        Collection fireables = transitionRelation.fireableTransitionsFrom(source);
        if (transitionRelation.hasBlockingTransitions()) {
            Iterator iterator = fireables.iterator();
            while (iterator.hasNext()) {
                Object fireable = iterator.next();
                IFiredTransition fired = transitionRelation.fireOneTransition(source, fireable);
                if (fired != null && !fired.getTargets().isEmpty()) continue;
                iterator.remove();
            }
        }
        return FXCollections.observableArrayList((Collection)fireables);
    }

    private void fireCallback(T transition) {
        ITransitionRelation transitionRelation = (ITransitionRelation)this.transitionRelationProperty.get();
        if (this.currentConfiguration.get() == null || transition == null) {
            return;
        }
        this.outFiredTransition.set((Object)transitionRelation.fireOneTransition(this.currentConfiguration.get(), transition));
    }
}

