/*
 * Decompiled with CFR 0.152.
 */
package plug.core.registry;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import plug.core.ILanguagePlugin;

public class LanguageModuleRegistry {
    private final Map<String, ILanguagePlugin> languageNameMap = new HashMap<String, ILanguagePlugin>();
    private final Map<String, ILanguagePlugin> extensionMap = new HashMap<String, ILanguagePlugin>();
    private static LanguageModuleRegistry instance = null;

    private LanguageModuleRegistry() {
    }

    public ILanguagePlugin getModuleByName(String name) {
        return this.languageNameMap.get(name);
    }

    public ILanguagePlugin getModuleByExtension(URI fileURI) {
        return this.getModuleByExtension(Paths.get(fileURI.getPath(), new String[0]));
    }

    public ILanguagePlugin getModuleByExtension(Path filePath) {
        if (filePath == null) {
            return null;
        }
        String fileName = filePath.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex < 1) {
            return null;
        }
        String fileExtension = fileName.substring(dotIndex);
        return this.extensionMap.get(fileExtension);
    }

    public Collection<ILanguagePlugin> getModules() {
        return Collections.unmodifiableCollection(this.languageNameMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LanguageModuleRegistry getInstance() {
        if (instance != null) return instance;
        Class<LanguageModuleRegistry> clazz = LanguageModuleRegistry.class;
        synchronized (LanguageModuleRegistry.class) {
            if (instance != null) return instance;
            instance = new LanguageModuleRegistry();
            for (ILanguagePlugin ilm : ServiceLoader.load(ILanguagePlugin.class)) {
                System.out.println("Loading " + ilm.getName() + " language plugin");
                LanguageModuleRegistry.instance.languageNameMap.put(ilm.getName(), ilm);
                for (String extension : ilm.getExtensions()) {
                    LanguageModuleRegistry.instance.extensionMap.put(extension, ilm);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

