/*
 * Decompiled with CFR 0.152.
 */
package spinja.concurrent.search;

import spinja.concurrent.model.ConcurrentModel;
import spinja.concurrent.model.ConcurrentTransition;
import spinja.concurrent.model.Process;
import spinja.model.MetaInfo;
import spinja.model.Transition;
import spinja.search.SearchableStack;
import spinja.search.TransitionCalculator;

public class PartialOrderReduction<M extends ConcurrentModel<T>, T extends ConcurrentTransition<T>>
extends TransitionCalculator<M, T> {
    @Override
    public T next(M m, T t) {
        ConcurrentTransition concurrentTransition;
        Process<T> process;
        int n = ((ConcurrentModel)m).getNrProcesses() - 1;
        if (t != null) {
            process = ((ConcurrentTransition)t).getProcess();
            if (process == null) {
                return null;
            }
            concurrentTransition = (ConcurrentTransition)process.nextTransition(t);
            if (concurrentTransition != null) {
                concurrentTransition.copyMetaInfo((Transition)t);
                return (T)concurrentTransition;
            }
            if (((Transition)t).hasMetaInfo(MetaInfo.PartialOrderReduction) && !((Transition)t).hasMetaInfo(MetaInfo.StateOnStack)) {
                return null;
            }
            n = ((ConcurrentTransition)t).getProcess().getId() - 1;
        }
        if (t == null || ((ConcurrentTransition)t).getProcess().onlyLocalTransitions()) {
            while (n >= 0) {
                if (!(process = ((ConcurrentModel)m).getProcess(n--)).onlyLocalTransitions() || (concurrentTransition = (ConcurrentTransition)process.nextTransition(null)) == null) continue;
                concurrentTransition.setMetaInfo(MetaInfo.PartialOrderReduction);
                return (T)concurrentTransition;
            }
            n = ((ConcurrentModel)m).getNrProcesses() - 1;
        }
        while (n >= 0) {
            if ((process = ((ConcurrentModel)m).getProcess(n--)).onlyLocalTransitions() || (concurrentTransition = (ConcurrentTransition)process.nextTransition(null)) == null) continue;
            return (T)concurrentTransition;
        }
        return null;
    }

    @Override
    public void duplicateState(M m, T t, byte[] byArray, int n, SearchableStack searchableStack) {
        if (((Transition)t).hasMetaInfo(MetaInfo.PartialOrderReduction) && searchableStack.containsState(byArray, n)) {
            ((Transition)t).setMetaInfo(MetaInfo.StateOnStack);
        }
    }
}

