/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.Optional;
import java.util.function.BiFunction;
import org.reactfx.EmissionBuilder;
import org.reactfx.EventStream;
import org.reactfx.StateMachine;
import org.reactfx.StatefulStreamBuilderImpl;
import org.reactfx.TransitionBuilder;
import org.reactfx.TransmissionBuilder;
import org.reactfx.util.LL;
import org.reactfx.util.Tuple2;

class StatefulStreamBuilderOnImpl<S, O, I>
implements StateMachine.StatefulStreamBuilderOn<S, O, I> {
    private final S initialState;
    private final LL<TransitionBuilder<S>> transitions;
    private final LL<EmissionBuilder<S, O>> emissions;
    private final LL<TransmissionBuilder<S, O>> transmissions;
    private final EventStream<I> input;

    StatefulStreamBuilderOnImpl(S initialState, LL<TransitionBuilder<S>> transitions, LL<EmissionBuilder<S, O>> emissions, LL<TransmissionBuilder<S, O>> transmissions, EventStream<I> input) {
        this.initialState = initialState;
        this.transitions = transitions;
        this.emissions = emissions;
        this.transmissions = transmissions;
        this.input = input;
    }

    @Override
    public StateMachine.StatefulStreamBuilder<S, O> transition(BiFunction<? super S, ? super I, ? extends S> f) {
        TransitionBuilder<? extends S> transition = new TransitionBuilder<S>(this.input, f);
        return new StatefulStreamBuilderImpl<S, O>(this.initialState, LL.cons(transition, this.transitions), this.emissions, this.transmissions);
    }

    @Override
    public StateMachine.StatefulStreamBuilder<S, O> emit(BiFunction<? super S, ? super I, Optional<O>> f) {
        EmissionBuilder<? super S, O> emission = new EmissionBuilder<S, O>(this.input, f);
        return new StatefulStreamBuilderImpl<S, O>(this.initialState, this.transitions, LL.cons(emission, this.emissions), this.transmissions);
    }

    @Override
    public StateMachine.StatefulStreamBuilder<S, O> transmit(BiFunction<? super S, ? super I, Tuple2<S, Optional<O>>> f) {
        TransmissionBuilder<? super S, O> transmission = new TransmissionBuilder<S, O>(this.input, f);
        return new StatefulStreamBuilderImpl<S, O>(this.initialState, this.transitions, this.emissions, LL.cons(transmission, this.transmissions));
    }
}

