/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations.forUML;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cte.ABCD.ABCDReplacer;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.builder.Builder;
import org.cte.ABCD.builder.ComplexBuilder;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.EventPool;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.statements.CaseStmt;
import org.cte.ABCD.model.statements.DeferredEvent;
import org.cte.ABCD.model.statements.SendStmt;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.types.Array;
import org.cte.ABCD.model.types.Union;
import org.cte.ABCD.transformations.forUML.TInlineEventPoolReceive;

public class TInlineEventPool {
    protected ABCDSystem currentSystem;
    protected Builder builder;
    private ComplexBuilder defBuilder;
    protected ABCDReplacer replacer = new ABCDReplacer();
    private Map<ChannelTypeDecl, TypeDecl> eventPool2Type = new HashMap<ChannelTypeDecl, TypeDecl>();
    private Map<ChannelDecl, VariableDecl> channel2Variable = new HashMap<ChannelDecl, VariableDecl>();
    protected Map<Port, ParameterDecl> port2Parameter = new HashMap<Port, ParameterDecl>();
    protected Map<ProcessDecl, ParameterDecl> processOwnedEventPool = new HashMap<ProcessDecl, ParameterDecl>();
    protected Map<ProcessDecl, Port> processOwnedEventPoolPort = new HashMap<ProcessDecl, Port>();
    private Set<ProcessDecl> processesUsingEventPool = new HashSet<ProcessDecl>();
    protected Map<TypeDecl, FunctionDecl> deferHandlerPerEventPoolType = new HashMap<TypeDecl, FunctionDecl>();

    public void runOn(ABCDSystem sys) throws Exception {
        this.currentSystem = sys;
        this.builder = new Builder(sys.getCoreTypesList());
        this.defBuilder = new ComplexBuilder(sys.getCoreTypesList());
        this.inlineEventPools();
    }

    private void inlineEventPools() throws Exception {
        this.processChannelTypes();
        this.processChannelDeclarations();
        this.processInstances();
        this.generateDeferredHandler();
        this.replaceSends();
        this.replaceReceives();
        this.currentSystem.accept(this.replacer);
    }

    private void generateDeferredHandler() {
        for (ProcessDecl process : this.processOwnedEventPool.keySet()) {
            process.accept(new ABCDWalker(new ABCDVisitor.Stub(){

                @Override
                public void visitDeferredEvent(DeferredEvent node) {
                    Type eventPoolType = TInlineEventPool.this.port2Parameter.get(node.getPort()).getType();
                    if (TInlineEventPool.this.deferHandlerPerEventPoolType.get(eventPoolType) == null) {
                        Type t = node.getPort().getType();
                        String vocabName = ((TypeDecl)eventPoolType).getName();
                        while (t instanceof TypeDecl) {
                            t = ((TypeDecl)t).getType();
                        }
                        Union vocab = (Union)t;
                        Array boolArr = TInlineEventPool.this.builder.array(vocab.getFieldsCount(), TInlineEventPool.this.builder.boolType());
                        TypeDecl deferMaskType = TInlineEventPool.this.builder.typeDecl("deferMask_" + vocabName, boolArr);
                        FunctionDecl defHandler = TInlineEventPool.this.defBuilder.createDeferredHandler(vocabName, vocab, (TypeDecl)eventPoolType, deferMaskType);
                        TInlineEventPool.this.currentSystem.addCoreTypes(boolArr);
                        TInlineEventPool.this.currentSystem.addTypes(deferMaskType);
                        TInlineEventPool.this.currentSystem.addDeclarations(deferMaskType);
                        TInlineEventPool.this.currentSystem.addFunctions(defHandler);
                        TInlineEventPool.this.deferHandlerPerEventPoolType.put((TypeDecl)eventPoolType, defHandler);
                    }
                }
            }));
        }
    }

    private void replaceReceives() throws Exception {
        TInlineEventPoolReceive receiveInliner = new TInlineEventPoolReceive(this);
        for (ProcessDecl process : this.processesUsingEventPool) {
            for (Transition t : process.getTransitionsList()) {
                receiveInliner.runOn(t);
            }
        }
    }

    private void replaceSends() {
        for (ProcessDecl process : this.processesUsingEventPool) {
            process.accept(new ABCDWalker(new ABCDVisitor.Stub(){

                @Override
                public void visitProcessDecl(ProcessDecl aNode) {
                    for (Transition t : aNode.getTransitionsList()) {
                        t.accept(this);
                    }
                }

                @Override
                public void visitSendStmt(SendStmt aNode) {
                    ParameterDecl param = TInlineEventPool.this.port2Parameter.get(aNode.getPort());
                    Expression value = aNode.getExpression();
                    CaseStmt stmt = TInlineEventPool.this.builder.caseStmt(TInlineEventPool.this.builder.not(TInlineEventPool.this.builder.full(TInlineEventPool.this.builder.reference(param))), TInlineEventPool.this.builder.caseItem((Expression)TInlineEventPool.this.builder.literal(true), TInlineEventPool.this.builder.enqueue(param, value)));
                    TInlineEventPool.this.replacer.addReplacement(aNode, stmt);
                }
            }));
        }
    }

    private void processInstances() {
        for (ProcessInstance instance : this.currentSystem.getCompositionList()) {
            instance.accept(new ABCDVisitor.Stub(){
                private ProcessInstance currentInstance;
                private VariableDecl eventPool = null;

                @Override
                public void visitProcessInstance(ProcessInstance i) {
                    this.currentInstance = i;
                    for (PortMap ins : i.getInputsList()) {
                        ins.accept(this);
                    }
                    for (PortMap outs : i.getOutputsList()) {
                        outs.accept(this);
                    }
                }

                @Override
                public void visitPortMap(PortMap arg) {
                    arg.getActual().accept(this);
                    if (this.eventPool != null) {
                        TInlineEventPool.this.replacer.addRemove(arg);
                        TInlineEventPool.this.replacer.addRemove(arg.getFormal());
                        ParameterDecl param = TInlineEventPool.this.port2Parameter.get(arg.getFormal());
                        if (param == null) {
                            TInlineEventPool.this.replacer.addRemove(arg.getFormal());
                            param = TInlineEventPool.this.builder.parameterDecl(arg.getFormal().getName(), this.eventPool.getType());
                            TInlineEventPool.this.port2Parameter.put(arg.getFormal(), param);
                            this.currentInstance.getProcess().addParametersAndOpposite(param);
                            TInlineEventPool.this.processesUsingEventPool.add(this.currentInstance.getProcess());
                            if (arg.getFormal().isIsInput()) {
                                TInlineEventPool.this.processOwnedEventPool.put(this.currentInstance.getProcess(), param);
                                TInlineEventPool.this.processOwnedEventPoolPort.put(this.currentInstance.getProcess(), arg.getFormal());
                            }
                        }
                        ArgumentMap aM = TInlineEventPool.this.builder.argumentMap(param, TInlineEventPool.this.builder.reference(this.eventPool));
                        this.currentInstance.addArgumentsAndOpposite(aM);
                    }
                    this.eventPool = null;
                }

                @Override
                public void visitReference(Reference ref) {
                    ref.getRef().accept(this);
                }

                @Override
                public void visitChannelDecl(ChannelDecl chan) {
                    this.eventPool = (VariableDecl)TInlineEventPool.this.channel2Variable.get(chan);
                }
            });
        }
    }

    private void processChannelDeclarations() {
        for (ChannelDecl cD : this.currentSystem.getChannelsList()) {
            TypeDecl type = this.eventPool2Type.get((ChannelTypeDecl)cD.getType());
            if (type == null) continue;
            this.replacer.addRemove(cD);
            VariableDecl var = this.builder.variableDecl(cD.getName(), type, this.builder.queueLiteral(new Expression[0]));
            this.currentSystem.addVariablesAndOpposite(var);
            this.channel2Variable.put(cD, var);
        }
    }

    private void processChannelTypes() {
        for (ChannelTypeDecl cTD : this.currentSystem.getChannelTypesList()) {
            if (!(cTD.getSynchronizationPolicy() instanceof EventPool)) continue;
            this.replacer.addRemove(cTD);
            Expression size = ((EventPool)cTD.getSynchronizationPolicy()).getSize();
            TypeDecl queueType = this.builder.queueTypeDecl(cTD.getName(), size, cTD.getType());
            this.currentSystem.addCoreTypes(queueType.getType());
            this.currentSystem.addTypes(queueType);
            this.currentSystem.addDeclarations(queueType);
            this.eventPool2Type.put(cTD, queueType);
        }
    }
}

