/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.ConstantDecl;
import org.cte.ABCD.model.declarations.Field;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.State;
import org.cte.ABCD.model.declarations.Synchronous;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.ValueHolder;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Any;
import org.cte.ABCD.model.expressions.ArrayLit;
import org.cte.ABCD.model.expressions.BinaryExp;
import org.cte.ABCD.model.expressions.BinaryOperator;
import org.cte.ABCD.model.expressions.BooleanLit;
import org.cte.ABCD.model.expressions.FalseLit;
import org.cte.ABCD.model.expressions.FieldLiteral;
import org.cte.ABCD.model.expressions.FunctionCall;
import org.cte.ABCD.model.expressions.IndexedExp;
import org.cte.ABCD.model.expressions.IntegerLit;
import org.cte.ABCD.model.expressions.QueueLit;
import org.cte.ABCD.model.expressions.RecordLit;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.expressions.SelectedExp;
import org.cte.ABCD.model.expressions.TrueLit;
import org.cte.ABCD.model.expressions.UnaryExp;
import org.cte.ABCD.model.expressions.UnaryOperator;
import org.cte.ABCD.model.expressions.UnionLiteral;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.statements.AssignStmt;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.CaseItem;
import org.cte.ABCD.model.statements.CaseStmt;
import org.cte.ABCD.model.statements.IfStmt;
import org.cte.ABCD.model.statements.InputStmt;
import org.cte.ABCD.model.statements.NullStmt;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.ReturnStmt;
import org.cte.ABCD.model.statements.SelectStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.statements.ToStmt;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.statements.WaitStmt;
import org.cte.ABCD.model.statements.WhileStmt;
import org.cte.ABCD.model.types.Array;
import org.cte.ABCD.model.types.BoolType;
import org.cte.ABCD.model.types.IntType;
import org.cte.ABCD.model.types.Interval;
import org.cte.ABCD.model.types.MutexType;
import org.cte.ABCD.model.types.NatType;
import org.cte.ABCD.model.types.NoneType;
import org.cte.ABCD.model.types.Queue;
import org.cte.ABCD.model.types.Record;
import org.cte.ABCD.model.types.SemaphoreType;
import org.cte.ABCD.model.types.TimerType;
import org.cte.ABCD.model.types.Union;

public class Builder {
    public static Type IntType = new IntType();
    public static Type NatType = new NatType();
    public static Type BoolType = new BoolType();
    public static Type NoneType = new NoneType();
    public static Type TimerType = new TimerType();
    public static Type MutexType = new MutexType();
    public static Type SemaphoreType = new SemaphoreType();
    private List<Type> primitiveTypes;

    public Builder() {
        this.primitiveTypes = Arrays.asList(IntType, BoolType, NatType, NoneType, TimerType, MutexType, SemaphoreType);
    }

    public Builder(List<Type> primitiveTypes) {
        this.primitiveTypes = primitiveTypes;
    }

    public <T extends Type> Type primitiveType(Class<T> typeClass) {
        for (Type t : this.primitiveTypes) {
            if (!typeClass.isInstance(t)) continue;
            return t;
        }
        try {
            return (Type)typeClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Type intType() {
        return this.primitiveType(IntType.class);
    }

    public Type boolType() {
        return this.primitiveType(BoolType.class);
    }

    public Type natType() {
        return this.primitiveType(NatType.class);
    }

    public Type noneType() {
        return this.primitiveType(NoneType.class);
    }

    public Type timerType() {
        return this.primitiveType(TimerType.class);
    }

    public Type mutexType() {
        return this.primitiveType(MutexType.class);
    }

    public Type semaphoreType() {
        return this.primitiveType(SemaphoreType.class);
    }

    public Type intervalType(int min, int max) {
        Interval i = new Interval();
        i.setMini(this.literal(min));
        i.setMaxi(this.literal(max));
        return i;
    }

    public List<Type> getPrimitiveTypes() {
        return this.primitiveTypes;
    }

    public void setPrimitiveTypes(List<Type> primitiveTypes) {
        this.primitiveTypes = primitiveTypes;
    }

    public ArgumentMap argumentMap(ParameterDecl formal, Expression actual) {
        ArgumentMap aM = new ArgumentMap();
        if (formal != null) {
            aM.setFormal(formal);
            aM.setFormalName(formal.getName());
        }
        aM.setActual(actual);
        return aM;
    }

    public ChannelTypeDecl syncChannelType(String name, Type dataType) {
        ChannelTypeDecl chanType = new ChannelTypeDecl();
        chanType.setName(name);
        chanType.setSynchronizationPolicy(new Synchronous());
        chanType.setType(dataType);
        return chanType;
    }

    public ChannelDecl syncChannel(String name, ChannelTypeDecl channelType) {
        ChannelDecl chan = new ChannelDecl();
        chan.setName(name);
        chan.setType(channelType);
        return chan;
    }

    public PortMap portMap(Port formal, Expression actual) {
        PortMap map = new PortMap();
        map.setFormal(formal);
        map.setActual(actual);
        return map;
    }

    public PortMap portMap(Port formal, ChannelDecl actual) {
        return this.portMap(formal, this.reference(actual));
    }

    public ProcessInstance instance(ProcessDecl process, ChannelDecl[] inputs, ChannelDecl[] outputs, Expression[] arguments) throws Exception {
        int argSize;
        int inSize = inputs == null ? 0 : inputs.length;
        int outSize = outputs == null ? 0 : outputs.length;
        int n = argSize = arguments == null ? 0 : arguments.length;
        if (process.getPortsList().size() != inSize + outSize) {
            System.err.println("Cannot create process instance with incorrect number of channels\n");
            throw new Exception();
        }
        if (process.getParametersList().size() != argSize) {
            System.err.println("Cannot create process instance with incorrect number of arguments\n");
            throw new Exception();
        }
        ProcessInstance instance = new ProcessInstance();
        instance.setProcess(process);
        int in = 0;
        int out = 0;
        ArrayList<PortMap> inMap = new ArrayList<PortMap>(inSize);
        ArrayList<PortMap> outMap = new ArrayList<PortMap>(outSize);
        for (Port port : process.getPortsList()) {
            PortMap map = new PortMap();
            map.setFormal(port);
            if (port.isIsInput()) {
                map.setActual(this.reference(inputs[in++]));
                inMap.add(map);
                continue;
            }
            map.setActual(this.reference(outputs[out++]));
            outMap.add(map);
        }
        int argI = 0;
        ArrayList<ArgumentMap> argMap = new ArrayList<ArgumentMap>(argSize);
        for (ParameterDecl attr : process.getParametersList()) {
            ArgumentMap map = new ArgumentMap();
            map.setFormal(attr);
            map.setActual(arguments[argI++]);
            argMap.add(map);
        }
        instance.addAllInputs(inMap);
        instance.addAllOutputs(outMap);
        instance.addAllArgumentsAndOpposite(argMap);
        return instance;
    }

    public Statement assign(Expression lhs, Expression rhs) {
        AssignStmt assignment = new AssignStmt();
        assignment.setLhs(lhs);
        assignment.setRhs(rhs);
        return assignment;
    }

    public OutputStmt output(Port port) {
        return this.output(port, null);
    }

    public OutputStmt output(Port port, Expression exp) {
        OutputStmt node = new OutputStmt();
        node.setPort(port);
        if (exp != null) {
            node.setExpression(exp);
        }
        return node;
    }

    public InputStmt input(Port port) {
        return this.input(port, null);
    }

    public InputStmt input(Port port, Expression exp) {
        InputStmt node = new InputStmt();
        node.setPort(port);
        if (exp != null) {
            node.setExpression(exp);
        }
        return node;
    }

    public SelectStmt select(Statement ... statements) {
        return this.select(Arrays.asList(statements));
    }

    public SelectStmt select(List<Statement> statements) {
        SelectStmt node = new SelectStmt();
        for (Statement statement : statements) {
            node.addStatements(statement);
        }
        return node;
    }

    public CaseStmt caseStmt(Expression exp, CaseItem ... items) {
        return this.caseStmt(exp, Arrays.asList(items));
    }

    public CaseStmt caseStmt(Expression exp, List<CaseItem> items) {
        CaseStmt stmt = new CaseStmt();
        stmt.setExpression(exp);
        stmt.addAllItems(items);
        return stmt;
    }

    public CaseItem caseItem(Expression value, Statement ... stmts) {
        return this.caseItem(value, (Statement)this.block(stmts));
    }

    public CaseItem caseItem(Expression value, Statement stm) {
        CaseItem stmt = new CaseItem();
        stmt.setExpression(value);
        stmt.setBlock(stm);
        return stmt;
    }

    public Block block(Statement ... statements) {
        return this.block(Arrays.asList(statements));
    }

    public Block block(List<Statement> stmts) {
        Block node = new Block();
        for (Statement s : stmts) {
            if (s == null) continue;
            if (s instanceof Block) {
                node.addAllStatements(((Block)s).getStatementsList());
                continue;
            }
            node.addStatements(s);
        }
        return node;
    }

    public ToStmt loopOn(Transition parent) {
        ToStmt to = new ToStmt();
        to.setState(parent.getFrom());
        return to;
    }

    public ToStmt toState(String name, ProcessDecl process) {
        ToStmt to = new ToStmt();
        to.setState(this.ensureState(name, process));
        return to;
    }

    public WhileStmt whileStmt(Expression condition, Block body) {
        WhileStmt stmt = new WhileStmt();
        stmt.setCondition(condition);
        stmt.setBody(body);
        return stmt;
    }

    public IfStmt ifStmt(Expression condition, Statement thenS, Statement elseS) {
        IfStmt ifStmt = new IfStmt();
        ifStmt.setCondition(condition);
        ifStmt.setTrueBranch(thenS);
        ifStmt.setFalseBranch(elseS);
        return ifStmt;
    }

    public Expression indexedExp(Expression prefix, Expression index) {
        IndexedExp exp = new IndexedExp();
        exp.setPrefix(prefix);
        exp.setIndex(index);
        return exp;
    }

    public Port port(String name, Type type, boolean isInput) {
        Port portDecl = new Port();
        portDecl.setName(name);
        portDecl.setType(type);
        portDecl.setIsInput(isInput);
        return portDecl;
    }

    public Field field(String name, Type type) {
        Field field = new Field();
        field.setName(name);
        field.setType(type);
        return field;
    }

    public Array array(int size, Type type) {
        Array array = new Array();
        array.setSize(this.literal(size));
        array.setType(type);
        return array;
    }

    public Record record(Field ... fields) {
        return this.record(Arrays.asList(fields));
    }

    public Record record(List<Field> fields) {
        Record record = new Record();
        for (Field f : fields) {
            record.addFields(f);
        }
        return record;
    }

    public RecordLit recordLiteral(FieldLiteral ... fields) {
        return this.recordLiteral(Arrays.asList(fields));
    }

    public RecordLit recordLiteral(List<FieldLiteral> fields) {
        RecordLit node = new RecordLit();
        if (fields == null) {
            return node;
        }
        for (FieldLiteral e : fields) {
            node.addValue(e);
        }
        return node;
    }

    public FieldLiteral fieldLiteral(String name, Expression value) {
        FieldLiteral node = new FieldLiteral();
        node.setName(name);
        node.setValue(value);
        return node;
    }

    public Expression selectedExp(Expression record, String field) {
        SelectedExp node = new SelectedExp();
        node.setPrefix(record);
        node.setSelector(field);
        return node;
    }

    public Queue queue(Expression size, Type type) {
        Queue queue = new Queue();
        queue.setSize(size);
        queue.setType(type);
        return queue;
    }

    public Statement enqueue(ValueHolder queue, Expression value) {
        SpecialTypeStmt stmt = new SpecialTypeStmt();
        stmt.setReceiver(queue);
        stmt.setSelector("write");
        stmt.addArguments(value);
        return stmt;
    }

    public TypeDecl queueTypeDecl(String name, Expression size, Type type) {
        return this.typeDecl(name, this.queue(size, type));
    }

    public QueueLit queueLiteral(Expression ... exps) {
        return this.queueLiteral(Arrays.asList(exps));
    }

    public QueueLit queueLiteral(List<Expression> exps) {
        QueueLit exp = new QueueLit();
        if (exps == null) {
            return exp;
        }
        for (Expression e : exps) {
            exp.addValue(e);
        }
        return exp;
    }

    public UnionLiteral unionLiteral(Union union, String selector, Expression exp) {
        UnionLiteral lit = new UnionLiteral();
        lit.setType(union);
        lit.setSelector(selector);
        lit.setExpression(exp);
        return lit;
    }

    public Any any() {
        return new Any();
    }

    public ConstantDecl constantDecl(String name, Type type, Expression value) {
        ConstantDecl var = new ConstantDecl();
        var.setName(name);
        var.setType(type);
        if (value != null) {
            var.setValue(value);
        }
        return var;
    }

    public VariableDecl lttVariableDecl(String name, Type type, Expression value) {
        VariableDecl var = this.variableDecl(name, type, value);
        var.setIsLTT(true);
        return var;
    }

    public VariableDecl variableDecl(String name, Type type, Expression value) {
        VariableDecl var = new VariableDecl();
        var.setName(name);
        var.setType(type);
        if (value != null) {
            var.setValue(value);
        }
        return var;
    }

    public ParameterDecl parameterDecl(String name, Type type) {
        ParameterDecl att = new ParameterDecl();
        att.setName(name);
        att.setType(type);
        return att;
    }

    public Transition transition(String source, ProcessDecl process) {
        Transition transition = new Transition();
        transition.setFrom(this.ensureState(source, process));
        process.addTransitionsAndOpposite(transition);
        return transition;
    }

    public TypeDecl typeDecl(String name, Type type) {
        TypeDecl decl = new TypeDecl();
        decl.setName(name);
        decl.setType(type);
        return decl;
    }

    public Reference reference(NamedDeclaration var) {
        Reference ref = new Reference();
        ref.setRef(var);
        return ref;
    }

    public State ensureState(String name, ProcessDecl process) {
        State state = this.lookupState(name, process);
        if (state != null) {
            return state;
        }
        state = new State();
        state.setName(name);
        process.addStatesAndOpposite(state);
        return state;
    }

    public State lookupState(String name, ProcessDecl process) {
        for (State state : process.getStatesList()) {
            if (!state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    public ProcessDecl process(String name, List<Port> ports, List<ParameterDecl> attrs, List<VariableDecl> vars) {
        ProcessDecl node = new ProcessDecl();
        node.setName(name);
        if (ports != null) {
            node.addAllPortsAndOpposite(ports);
        }
        if (attrs != null) {
            node.addAllParametersAndOpposite(attrs);
        }
        if (vars != null) {
            node.addAllVariables(vars);
        }
        return node;
    }

    public WaitStmt wait(Expression min, Expression max) {
        WaitStmt node = new WaitStmt();
        node.setMinBound(min);
        node.setMaxBound(max);
        return node;
    }

    public IntegerLit literal(int v) {
        IntegerLit i = new IntegerLit();
        i.setValue(v);
        return i;
    }

    public BooleanLit literal(boolean v) {
        return v ? new TrueLit() : new FalseLit();
    }

    public Expression and(Expression e1, Expression e2) {
        return this.expression(BinaryOperator.BAND, e1, e2);
    }

    public Expression minus(Expression exp) {
        return this.expression(UnaryOperator.UMINUS, exp);
    }

    public Expression not(Expression exp) {
        return this.expression(UnaryOperator.UNOT, exp);
    }

    public Expression full(Expression exp) {
        return this.selectedExp(exp, "full");
    }

    public Expression empty(Expression exp) {
        return this.selectedExp(exp, "empty");
    }

    public Expression dequeue(Expression exp) {
        return this.selectedExp(exp, "dequeue");
    }

    public Expression first(Expression exp) {
        return this.selectedExp(exp, "first");
    }

    public Expression expression(BinaryOperator op, Expression lhs, Expression rhs) {
        BinaryExp e = new BinaryExp();
        e.setOperator(op);
        e.addOperands(lhs);
        e.addOperands(rhs);
        return e;
    }

    public Expression expression(UnaryOperator op, Expression lhs) {
        UnaryExp e = new UnaryExp();
        e.setOperator(op);
        e.setOperand(lhs);
        return e;
    }

    public Statement increment(VariableDecl var, Expression value) {
        return this.assign(this.reference(var), this.expression(BinaryOperator.BADD, this.reference(var), value));
    }

    public Statement increment(VariableDecl var) {
        return this.increment(var, this.literal(1));
    }

    public Statement decrement(VariableDecl var, Expression value) {
        return this.assign(this.reference(var), this.expression(BinaryOperator.BMINUS, this.reference(var), value));
    }

    public Statement decrement(VariableDecl var) {
        return this.decrement(var, this.literal(1));
    }

    public Statement nullStmt() {
        return new NullStmt();
    }

    public ABCDSystem system(String name) {
        ABCDSystem sys = new ABCDSystem();
        sys.addAllCoreTypes(Arrays.asList(IntType, BoolType, NatType, NoneType, TimerType, MutexType, SemaphoreType));
        sys.setName(name);
        return sys;
    }

    public ABCDSystem addProcess(ProcessDecl process, final ABCDSystem sys) {
        sys.addProcesses(process);
        process.accept(new ABCDVisitor.Stub(){

            @Override
            public void visitProcessDecl(ProcessDecl node) {
                for (Port p : node.getPortsList()) {
                    p.getType().accept(this);
                }
                for (ParameterDecl a : node.getParametersList()) {
                    a.getType().accept(this);
                }
                for (VariableDecl v : node.getVariablesList()) {
                    v.getType().accept(this);
                }
            }

            @Override
            public void visitTypeDecl(TypeDecl node) {
                node.getType().accept(this);
                if (!sys.getTypesList().contains(node)) {
                    sys.addTypes(node);
                }
            }

            @Override
            public void visitArray(Array node) {
                node.getType().accept(this);
                if (!sys.getCoreTypesList().contains(node)) {
                    sys.addCoreTypes(node);
                }
            }

            @Override
            public void visitQueue(Queue node) {
                node.getType().accept(this);
                if (!sys.getCoreTypesList().contains(node)) {
                    sys.addCoreTypes(node);
                }
            }

            @Override
            public void visitField(Field node) {
                node.getType().accept(this);
            }

            @Override
            public void visitRecord(Record node) {
                for (Field f : node.getFieldsList()) {
                    f.accept(this);
                }
                if (!sys.getCoreTypesList().contains(node)) {
                    sys.addCoreTypes(node);
                }
            }

            @Override
            public void visitInterval(Interval node) {
                if (!sys.getCoreTypesList().contains(node)) {
                    sys.addCoreTypes(node);
                }
            }

            @Override
            public void visitUnion(Union node) {
                for (Field f : node.getFieldsList()) {
                    f.accept(this);
                }
                if (!sys.getCoreTypesList().contains(node)) {
                    sys.addCoreTypes(node);
                }
            }
        });
        process.accept(new ABCDWalker(new ABCDVisitor.Stub(){

            @Override
            public void visitReference(Reference ref) {
                NamedDeclaration target = ref.getRef();
                if (target instanceof ConstantDecl && !sys.getConstantsList().contains(target)) {
                    sys.addConstants((ConstantDecl)target);
                }
            }
        }));
        return sys;
    }

    public Expression arrayLiteral(Expression ... values) {
        return this.arrayLiteral(Arrays.asList(values));
    }

    public Expression arrayLiteral(List<Expression> values) {
        ArrayLit lit = new ArrayLit();
        lit.addAllValue(values);
        return lit;
    }

    public Expression functionCall(String functionName, ArgumentMap ... arguments) {
        return this.functionCall(functionName, Arrays.asList(arguments));
    }

    private Expression functionCall(String functionName, List<ArgumentMap> args) {
        FunctionCall fctCall = new FunctionCall();
        fctCall.setFunctionName(functionName);
        fctCall.addAllArgumentsAndOpposite(args);
        return fctCall;
    }

    public FunctionDecl functionDecl(String name, ParameterDecl[] params, Type returnType, VariableDecl[] vars, Block body) {
        return this.functionDecl(name, Arrays.asList(params), returnType, Arrays.asList(vars), body);
    }

    public FunctionDecl functionDecl(String name, List<ParameterDecl> params, Type returnType, List<VariableDecl> vars, Block body) {
        FunctionDecl func = new FunctionDecl();
        func.setName(name);
        func.addAllParameters(params);
        func.setType(returnType);
        func.addAllVariables(vars);
        func.setBody(body);
        return func;
    }

    public Statement returnStmt(Expression result) {
        ReturnStmt stmt = new ReturnStmt();
        stmt.setExpression(result);
        return stmt;
    }
}

