/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.HashSet;
import java.util.Set;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.MyParseException;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;

public class AritmicExpression
extends Expression {
    private static final long serialVersionUID = -4022528945025403911L;
    private final Expression ex1;
    private final Expression ex2;
    private final Expression ex3;

    public AritmicExpression(Token token, Expression expression) {
        this(token, expression, null, null);
    }

    public AritmicExpression(Token token, Expression expression, Expression expression2) {
        this(token, expression, expression2, null);
    }

    public AritmicExpression(Token token, Expression expression, Expression expression2, Expression expression3) {
        super(token);
        this.ex1 = expression;
        this.ex2 = expression2;
        this.ex3 = expression3;
    }

    @Override
    public String getBoolExpression() throws ParseException {
        if (this.ex2 == null) {
            return "(" + this.getToken().image + this.ex1.getIntExpression() + " != 0)";
        }
        if (this.ex3 == null) {
            return "(" + this.ex1.getIntExpression() + " " + this.getToken().image + " " + this.ex2.getIntExpression() + " != 0)";
        }
        return "(" + this.ex1.getBoolExpression() + " ? " + this.ex2.getBoolExpression() + " : " + this.ex3.getBoolExpression() + ")";
    }

    @Override
    public int getConstantValue() throws ParseException {
        switch (this.getToken().kind) {
            case 81: {
                return this.ex1.getConstantValue() & this.ex2.getConstantValue();
            }
            case 83: {
                return this.ex1.getConstantValue() | this.ex2.getConstantValue();
            }
            case 66: {
                return ~this.ex1.getConstantValue();
            }
            case 68: {
                if (this.ex2 == null) {
                    return -this.ex1.getConstantValue();
                }
                return this.ex1.getConstantValue() - this.ex2.getConstantValue();
            }
            case 69: {
                return this.ex1.getConstantValue() * this.ex2.getConstantValue();
            }
            case 70: {
                return this.ex1.getConstantValue() / this.ex2.getConstantValue();
            }
            case 71: {
                return this.ex1.getConstantValue() % this.ex2.getConstantValue();
            }
            case 72: {
                return this.ex1.getConstantValue() + this.ex2.getConstantValue();
            }
            case 82: {
                return this.ex1.getConstantValue() ^ this.ex2.getConstantValue();
            }
            case 73: {
                return this.ex1.getConstantValue() << this.ex2.getConstantValue();
            }
            case 74: {
                return this.ex1.getConstantValue() >>> this.ex2.getConstantValue();
            }
        }
        throw new MyParseException("Unimplemented aritmic type: " + this.getToken().image, this.getToken());
    }

    @Override
    public String getIntExpression() throws ParseException {
        if (this.ex2 == null) {
            return "(" + this.getToken().image + this.ex1.getIntExpression() + ")";
        }
        if (this.ex3 == null) {
            if (this.getToken().image.equals("%")) {
                return "Math.abs(" + this.ex1.getIntExpression() + " % " + this.ex2.getIntExpression() + ")";
            }
            return "(" + this.ex1.getIntExpression() + " " + this.getToken().image + " " + this.ex2.getIntExpression() + ")";
        }
        return "(" + this.ex1.getBoolExpression() + " ? " + this.ex2.getIntExpression() + " : " + this.ex3.getIntExpression() + ")";
    }

    @Override
    public VariableType getResultType() {
        return VariableType.INT;
    }

    @Override
    public String getSideEffect() throws ParseException {
        String string = this.ex1.getSideEffect();
        if (this.ex2 != null) {
            if (string == null || this.ex2.getSideEffect() == null) {
                string = this.ex2.getSideEffect();
            } else {
                throw new MyParseException("More than one side-effect found in a single expression!", this.getToken());
            }
        }
        if (this.ex3 != null) {
            if (string == null || this.ex3.getSideEffect() == null) {
                string = this.ex3.getSideEffect();
            } else {
                throw new MyParseException("More than one side-effect found in a single expression!", this.getToken());
            }
        }
        return string;
    }

    @Override
    public Set<VariableAccess> readVariables() {
        HashSet<VariableAccess> hashSet = new HashSet<VariableAccess>();
        if (this.ex1 != null) {
            hashSet.addAll(this.ex1.readVariables());
        }
        if (this.ex2 != null) {
            hashSet.addAll(this.ex2.readVariables());
        }
        if (this.ex3 != null) {
            hashSet.addAll(this.ex3.readVariables());
        }
        return hashSet;
    }

    @Override
    public String toString() {
        if (this.ex2 == null) {
            return "(" + this.getToken().image + this.ex1.toString() + ")";
        }
        if (this.ex3 == null) {
            return "(" + this.ex1.toString() + " " + this.getToken().image + " " + this.ex2.toString() + ")";
        }
        return "(" + this.ex1.toString() + " ? " + this.ex2.toString() + " : " + this.ex3.toString() + ")";
    }
}

