/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.model;

import java.lang.reflect.Method;
import org.xid.basics.model.ChangeMark;
import org.xid.basics.model.ModelObject;

public class AttributeChangeMark
extends ChangeMark {
    protected final ModelObject receiver;
    protected final String attributeName;
    protected final Object oldValue;

    public AttributeChangeMark(long timestamp, ModelObject receiver, String attributeName, Object oldValue) {
        super(timestamp);
        this.receiver = receiver;
        this.attributeName = attributeName;
        this.oldValue = oldValue;
    }

    protected String getSetterName() {
        String firstUppercaseAttribute = this.attributeName.substring(0, 1).toUpperCase() + this.attributeName.substring(1);
        return "set" + firstUppercaseAttribute;
    }

    protected Method getUndoMethod() {
        Class<?> parameterType;
        Method method = null;
        String name = this.getSetterName();
        Class<?> receiverClass = this.receiver.getClass();
        method = this.getMethod(receiverClass, name, parameterType = this.oldValue == null ? null : this.oldValue.getClass());
        if (method == null) {
            if (parameterType == Boolean.class) {
                method = this.getMethod(receiverClass, name, Boolean.TYPE);
            } else if (parameterType == Character.class) {
                method = this.getMethod(receiverClass, name, Character.TYPE);
            } else if (parameterType == Byte.class) {
                method = this.getMethod(receiverClass, name, Byte.TYPE);
            } else if (parameterType == Short.class) {
                method = this.getMethod(receiverClass, name, Short.TYPE);
            } else if (parameterType == Integer.class) {
                method = this.getMethod(receiverClass, name, Integer.TYPE);
            } else if (parameterType == Long.class) {
                method = this.getMethod(receiverClass, name, Long.TYPE);
            } else if (parameterType == Float.class) {
                method = this.getMethod(receiverClass, name, Float.TYPE);
            } else if (parameterType == Double.class) {
                method = this.getMethod(receiverClass, name, Double.TYPE);
            }
        }
        return method;
    }

    @Override
    public void undo() {
        try {
            Method method = this.getUndoMethod();
            if (method != null) {
                method.invoke((Object)this.receiver, this.oldValue);
            } else {
                System.err.println("AttributeChangeMark.undo(): No method to undo");
            }
        }
        catch (Exception e) {
            System.err.println("AttributeChangeMark.undo(): " + e.getClass().getName());
        }
    }

    @Override
    public String toString() {
        return "At|" + this.attributeName;
    }
}

