/*
 * Decompiled with CFR 0.152.
 */
package plug.simulation.ui.fx;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.execution.IExecutionViewContext;
import plug.core.fx.ConfigurationListView;
import plug.core.fx.ConfigurationTreeView;
import plug.core.fx.FiredTransitionListView;
import plug.core.fx.event.ConfigurationActionEvent;
import plug.simulation.trace_storage.TraceEntry;
import plug.simulation.ui.fx.SimulationGraphViewModel;
import plug.utils.ui.graph.GraphView;
import plug.utils.ui.graph.GraphViewModel;

@Deprecated
public class SimulationView
extends SplitPane {
    protected final IExecutionViewContext context;
    protected final ConfigurationListView configurationListView;
    protected final FiredTransitionListView firedTransitionListView;
    protected final ConfigurationTreeView configurationTreeView;
    protected final GraphView<TraceEntry<IConfiguration, ?>, Object> currentGraph;
    protected final ObservableSet<IConfiguration> configurationSet;
    protected final SimulationGraphViewModel model;
    protected final Random transitionRandom = new Random();

    public SimulationView(IExecutionViewContext context, ObservableSet<IConfiguration> configurationSet) {
        this(context, configurationSet, Collections.emptyList());
    }

    public SimulationView(IExecutionViewContext context, ObservableSet<IConfiguration> configurationSet, List<IConfiguration> counterExample) {
        this(context, configurationSet, new SimulationGraphViewModel(context));
        IConfiguration counterExampleStart = null;
        if (counterExample != null && !counterExample.isEmpty()) {
            counterExampleStart = counterExample.get(0);
            TraceEntry initial = new TraceEntry(null, (Object)counterExampleStart);
            this.configurationSet.add((Object)counterExampleStart);
            this.model.getInitialVertices().add((Object)initial);
            TraceEntry previous = initial;
            for (int i = 1; i < counterExample.size(); ++i) {
                IConfiguration target = counterExample.get(i);
                TraceEntry entry = new TraceEntry(previous, (Object)target);
                IFiredTransition transition = context.getRuntime().firedTransitionForSourceToTarget(previous.getConfiguration(), (Object)target);
                this.model.addEdge(previous, entry, transition != null ? transition.getAction() : null);
                previous = entry;
            }
            this.currentGraph.setSelectedVertex((Object)previous);
        }
        Set initialConfigurations = context.getRuntime().initialConfigurations();
        for (IConfiguration initialConfiguration : initialConfigurations) {
            if (counterExampleStart != null && counterExampleStart.equals((Object)initialConfiguration)) continue;
            TraceEntry initialEntry = new TraceEntry(null, (Object)initialConfiguration);
            this.configurationSet.add((Object)initialConfiguration);
            this.model.getInitialVertices().add((Object)initialEntry);
            this.currentGraph.setSelectedVertex((Object)initialEntry);
        }
    }

    public SimulationView(IExecutionViewContext context, ObservableSet<IConfiguration> configurationSet, SimulationGraphViewModel model) {
        this.context = context;
        this.configurationSet = configurationSet;
        this.model = model;
        ObservableList configurationList = FXCollections.observableArrayList(configurationSet);
        configurationSet.addListener(change -> {
            if (change.getElementAdded() != null) {
                configurationList.add(change.getElementAdded());
            }
        });
        this.configurationListView = new ConfigurationListView(context, (ObservableList<IConfiguration>)configurationList);
        for (TraceEntry entry : model.getInitialVertices()) {
            configurationSet.add(entry.getConfiguration());
        }
        for (GraphViewModel.Edge edge : model.getEdges()) {
            configurationSet.add(((TraceEntry)edge.target).getConfiguration());
        }
        this.firedTransitionListView = new FiredTransitionListView(context);
        this.firedTransitionListView.setHideSourceConfigurations(true);
        this.firedTransitionListView.setConfigurationColorSupplier(model::configurationColor);
        Tab transitionsTab = new Tab(null, (Node)this.firedTransitionListView);
        transitionsTab.setGraphic((Node)new FontIcon("gmi-input"));
        Tab configurationsTab = new Tab(null, (Node)this.configurationListView);
        configurationsTab.setGraphic((Node)new FontIcon("gmi-format-list-numbered"));
        TabPane controlPane = new TabPane(new Tab[]{transitionsTab, configurationsTab});
        controlPane.setSide(Side.LEFT);
        controlPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.configurationTreeView = new ConfigurationTreeView(context);
        SplitPane topPane = new SplitPane(new Node[]{controlPane, this.configurationTreeView});
        topPane.setOrientation(Orientation.HORIZONTAL);
        this.currentGraph = new GraphView();
        this.currentGraph.setPrefSize(400.0, 300.0);
        this.currentGraph.setModel((GraphViewModel)model);
        this.currentGraph.setNodeFolding(true);
        this.currentGraph.beHorizontal();
        Button fireTransitionButton = new Button(null, (Node)new FontIcon("typ-arrow-shuffle"));
        fireTransitionButton.setTooltip(new Tooltip("Fire a transition randomly chosen from selected configuration"));
        fireTransitionButton.setOnAction(event -> {
            ObservableList transitions = this.firedTransitionListView.getItems();
            if (transitions.size() > 0) {
                int index = this.transitionRandom.nextInt(transitions.size());
                IFiredTransition transition = (IFiredTransition)transitions.get(index);
                this.handleFireTransition(new ConfigurationActionEvent((Object)this, (IFiredTransition<IConfiguration, Object>)transition, (IConfiguration)transition.getTarget(0)));
            }
        });
        ToggleButton hideDetailsButton = new ToggleButton(null, (Node)new FontIcon("gmi-photo-size-select-small"));
        hideDetailsButton.setTooltip(new Tooltip("Show/hide details in configurations"));
        hideDetailsButton.selectedProperty().bindBidirectional((Property)this.currentGraph.hideAllDetailsProperty());
        ToggleButton coloredButton = new ToggleButton(null, (Node)new FontIcon("gmi-color-lens"));
        coloredButton.setTooltip(new Tooltip("Show/hide colors of configurations"));
        coloredButton.selectedProperty().bindBidirectional((Property)this.currentGraph.coloredNodesProperty());
        Button saveImageButton = new Button(null, (Node)new FontIcon("typ-export"));
        saveImageButton.setTooltip(new Tooltip("Save graph view to image"));
        saveImageButton.setOnAction(event -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select file where to save image");
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG image", new String[]{"*.png"}));
            File file = chooser.showSaveDialog(this.getScene().getWindow());
            if (file != null) {
                try {
                    this.currentGraph.savePngImage(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        BorderPane graphPane = new BorderPane(this.currentGraph);
        HBox toolkitPane = new HBox(5.0, new Node[]{fireTransitionButton, new Separator(Orientation.VERTICAL), hideDetailsButton, coloredButton, new Separator(Orientation.VERTICAL), saveImageButton});
        toolkitPane.setPadding(new Insets(5.0));
        graphPane.setTop((Node)toolkitPane);
        this.configurationListView.setOnConfigurationAction((EventHandler<ConfigurationActionEvent>)((EventHandler)event -> this.selectConfiguration(event.getConfiguration())));
        this.firedTransitionListView.setOnConfigurationAction((EventHandler<ConfigurationActionEvent>)((EventHandler)this::handleFireTransition));
        this.currentGraph.selectedVertexProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.selectConfiguration((IConfiguration)newValue.getConfiguration());
            }
        });
        this.currentGraph.coloredNodesProperty().addListener((observable, oldValue, newValue) -> {
            this.firedTransitionListView.setConfigurationColorSupplier(newValue.booleanValue() ? model::configurationColor : null);
            this.firedTransitionListView.refresh();
        });
        this.setOrientation(Orientation.VERTICAL);
        this.getItems().addAll((Object[])new Node[]{topPane, graphPane});
        this.setDividerPosition(0, 0.3);
    }

    public SimulationGraphViewModel getModel() {
        return this.model;
    }

    protected void selectConfiguration(IConfiguration configuration) {
        this.configurationTreeView.setOther(this.configurationTreeView.getConfiguration());
        this.configurationTreeView.setConfiguration(configuration);
        this.firedTransitionListView.setConfiguration(configuration);
        TraceEntry selectedVertex = (TraceEntry)this.currentGraph.getSelectedVertex();
        if (configuration == null) {
            this.currentGraph.setSelectedVertex(null);
        } else if (selectedVertex == null || selectedVertex.getConfiguration() != configuration) {
            TraceEntry found = null;
            for (TraceEntry entry : this.model.getInitialVertices()) {
                if (!entry.getConfiguration().equals(configuration)) continue;
                found = entry;
                break;
            }
            if (found == null) {
                for (GraphViewModel.Edge edge : this.model.getEdges()) {
                    if (((IConfiguration)((TraceEntry)edge.source).getConfiguration()).equals((Object)configuration)) {
                        found = (TraceEntry)edge.source;
                        break;
                    }
                    if (!((IConfiguration)((TraceEntry)edge.target).getConfiguration()).equals((Object)configuration)) continue;
                    found = (TraceEntry)edge.target;
                    break;
                }
            }
            this.currentGraph.setSelectedVertex(found);
        }
    }

    protected void handleFireTransition(ConfigurationActionEvent event) {
        this.configurationSet.add((Object)event.getConfiguration());
        if (this.currentGraph.getSelectedVertex() != null) {
            TraceEntry sourceEntry = (TraceEntry)this.currentGraph.getSelectedVertex();
            TraceEntry targetEntry = new TraceEntry(sourceEntry, (Object)event.getConfiguration());
            GraphViewModel.Edge edge = this.model.addEdge(sourceEntry, targetEntry, event.getTransition().getAction());
            this.currentGraph.setSelectedVertex(edge.target);
        } else {
            TraceEntry sourceEntry = new TraceEntry(null, event.getTransition().getSource());
            this.model.getInitialVertices().add((Object)sourceEntry);
            TraceEntry targetEntry = new TraceEntry(sourceEntry, (Object)event.getConfiguration());
            GraphViewModel.Edge edge = this.model.addEdge(sourceEntry, targetEntry, event.getTransition().getAction());
            this.currentGraph.setSelectedVertex(edge.target);
        }
    }
}

