/*
 * Decompiled with CFR 0.152.
 */
package plug.simulation.trace_storage;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import plug.simulation.trace_storage.TraceEntry;

public class TraceStore<C, A> {
    public boolean hasCounterExample = false;
    Set<TraceEntry<C, A>> roots = new HashSet<TraceEntry<C, A>>();
    TraceEntry<C, A> lastEntry;
    Consumer<TraceEntry<C, A>> addRootUserCallback;
    Consumer<TraceEntry<C, A>> addStepUserCallback;

    public void setAddRootUserCallback(Consumer<TraceEntry<C, A>> addRootUserCallback) {
        this.addRootUserCallback = addRootUserCallback;
    }

    public void setAddStepUserCallback(Consumer<TraceEntry<C, A>> addStepUserCallback) {
        this.addStepUserCallback = addStepUserCallback;
    }

    public TraceEntry<C, A> getLastEntry() {
        return this.lastEntry;
    }

    public TraceEntry<C, A> addRoot(C rootEntry) {
        if (rootEntry == null) {
            return null;
        }
        TraceEntry entry = new TraceEntry(rootEntry);
        this.roots.add(entry);
        if (this.addRootUserCallback != null) {
            this.addRootUserCallback.accept(entry);
        }
        this.lastEntry = entry;
        return entry;
    }

    public void addRoots(Collection<C> rootEntries) {
        rootEntries.forEach(this::addRoot);
    }

    public Collection<TraceEntry<C, A>> getRoots() {
        return this.roots;
    }

    public TraceEntry<C, A> addStep(TraceEntry<C, A> sourceEntry, C target, A action) {
        if (target == null) {
            return null;
        }
        TraceEntry<C, A> targetEntry = new TraceEntry<C, A>(sourceEntry, target, action);
        if (sourceEntry == null) {
            this.roots.add(targetEntry);
        }
        if (this.addStepUserCallback != null) {
            this.addStepUserCallback.accept(targetEntry);
        }
        this.lastEntry = targetEntry;
        return targetEntry;
    }

    public TraceEntry<C, A> addSteps(TraceEntry<C, A> potentialSource, List<C> followingSteps, BiFunction<C, C, A> actionsProvider) {
        if (potentialSource == null) {
            return this.addSteps(Collections.emptyList(), followingSteps, actionsProvider);
        }
        return this.addSteps(Collections.singleton(potentialSource), followingSteps, actionsProvider);
    }

    public TraceEntry<C, A> addSteps(Collection<TraceEntry<C, A>> potentialSources, List<C> followingSteps, BiFunction<C, C, A> actionsProvider) {
        if (followingSteps == null || followingSteps.isEmpty()) {
            return null;
        }
        C firstC = followingSteps.get(0);
        TraceEntry<C, A> initial = null;
        initial = this.getAMatchingTraceEntry(this.roots, firstC);
        if (initial == null) {
            initial = this.getAMatchingTraceEntry(potentialSources, firstC);
        }
        if (initial == null) {
            initial = this.addRoot(firstC);
        }
        TraceEntry<C, A> previous = initial;
        for (int i = 1; i < followingSteps.size(); ++i) {
            C current = followingSteps.get(i);
            previous = this.addStep(previous, current, actionsProvider.apply(previous.getConfiguration(), current));
        }
        return previous;
    }

    TraceEntry<C, A> getAMatchingTraceEntry(Collection<TraceEntry<C, A>> collection, C target) {
        for (TraceEntry<C, A> traceEntry : collection) {
            if (!traceEntry.getConfiguration().equals(target)) continue;
            return traceEntry;
        }
        return null;
    }

    public void iterateOverTrace() {
        for (TraceEntry<C, A> root : this.roots) {
            this.dfs(root);
        }
    }

    void dfs(TraceEntry<C, A> entry) {
        if (entry.getParent() == null) {
            this.addRootUserCallback.accept(entry);
        } else {
            this.addStepUserCallback.accept(entry);
        }
        for (TraceEntry<C, A> child : entry.getChildren()) {
            this.dfs(child);
        }
    }
}

