/*
 * Decompiled with CFR 0.152.
 */
package plug.language.remote.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.core.RuntimeDescription;
import plug.core.view.ConfigurationItem;
import plug.language.remote.client.IRuntimeSerializer;

public class DistantRuntime {
    protected final String address;
    protected final int port;
    protected final RuntimeDescription description;
    protected final IRuntimeSerializer serializer;
    protected ServerSocket serverSocket;
    protected Socket connectedSocket;
    protected BufferedInputStream inputStream;
    protected BufferedOutputStream outputStream;
    protected ITransitionRelation<IConfiguration, Object> runtime;

    public DistantRuntime(int port, RuntimeDescription description, IRuntimeSerializer serializer) {
        this("127.0.0.1", port, description, serializer);
    }

    public DistantRuntime(String address, int port, RuntimeDescription description, IRuntimeSerializer serializer) {
        this.address = address;
        this.port = port;
        this.description = description;
        this.serializer = serializer;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public RuntimeDescription getDescription() {
        return this.description;
    }

    public void connect() throws Exception {
        this.serverSocket = new ServerSocket(this.port);
        this.connectedSocket = this.serverSocket.accept();
        this.inputStream = new BufferedInputStream(this.connectedSocket.getInputStream());
        this.outputStream = new BufferedOutputStream(this.connectedSocket.getOutputStream());
        this.runtime = this.description.getRuntime();
    }

    private byte[] readData(int size) throws IOException {
        byte[] data = new byte[size];
        int read = 0;
        while ((read += this.inputStream.read(data, 0, size)) < size) {
        }
        return data;
    }

    private int readInt() throws IOException {
        return ByteBuffer.wrap(this.readData(4)).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private long readLong() throws IOException {
        return ByteBuffer.wrap(this.readData(8)).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    private String readString() throws IOException {
        int size = this.readInt();
        return size < 0 ? null : new String(this.readData(size), StandardCharsets.UTF_8);
    }

    private ConfigurationItem readConfigurationItem() throws IOException {
        String type = this.readString();
        String name = this.readString();
        String icon = this.readString();
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        int childrenCount = this.readInt();
        for (int i = 0; i < childrenCount; ++i) {
            children.add(this.readConfigurationItem());
        }
        return new ConfigurationItem(type, name, icon, children);
    }

    private void writeData(byte[] data) throws IOException {
        if (data != null) {
            this.outputStream.write(data);
        }
    }

    private void writeInt(int value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(value);
        this.writeData(buffer.array());
    }

    private void writeLong(long value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(value);
        this.writeData(buffer.array());
    }

    private void writeString(String value) throws IOException {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : null;
        if (bytes != null) {
            this.writeInt(bytes.length);
            this.writeData(bytes);
        } else {
            this.writeInt(0);
        }
    }

    private void writeConfigurationItem(ConfigurationItem item) throws IOException {
        this.writeString(item.getType());
        this.writeString(item.getName());
        this.writeString(item.getIcon());
        this.writeInt(item.getChildren().size());
        for (ConfigurationItem child : item.getChildren()) {
            this.writeConfigurationItem(child);
        }
    }

    public void sendConfigurations(Collection<IConfiguration> configurations) throws IOException {
        this.writeInt(configurations.size());
        this.writeLong(this.serializer.getConfigurationSize());
        for (IConfiguration configuration : configurations) {
            this.writeData(this.serializer.serializeConfiguration(configuration));
        }
    }

    public void sendTransitions(Collection<Object> transitions) throws IOException {
        this.writeInt(transitions.size());
        this.writeLong(this.serializer.getTransitionSize());
        for (Object transition : transitions) {
            this.writeData(this.serializer.serializeTransition(transition));
        }
    }

    public void handleInitialConfigurations() throws IOException {
        this.sendConfigurations(this.runtime.initialConfigurations());
        this.outputStream.flush();
    }

    public void handleFireableTransitions() throws IOException {
        byte[] buffer = this.readData(this.serializer.getConfigurationSize());
        Object configuration = this.serializer.deserializeConfiguration(buffer);
        this.sendTransitions(this.runtime.fireableTransitionsFrom(configuration));
        this.outputStream.flush();
    }

    public void handleFireTransition() throws IOException {
        byte[] configurationBuffer = this.readData(this.serializer.getConfigurationSize());
        Object configuration = this.serializer.deserializeConfiguration(configurationBuffer);
        byte[] transitionBuffer = this.readData(this.serializer.getTransitionSize());
        Object transition = this.serializer.deserializeTransition(transitionBuffer);
        IFiredTransition fired = this.runtime.fireOneTransition(configuration, transition);
        this.sendConfigurations(fired.getTargets());
        this.outputStream.flush();
    }

    public boolean handleRequest() throws IOException {
        int status = this.inputStream.read();
        if (status == 1) {
            byte request = (byte)this.inputStream.read();
            switch (request) {
                case 1: {
                    this.handleInitialConfigurations();
                    break;
                }
                case 2: {
                    this.handleFireableTransitions();
                    break;
                }
                case 3: {
                    this.handleFireTransition();
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 10: {
                    this.readData(this.serializer.getConfigurationSize());
                    this.writeInt(0);
                    this.outputStream.flush();
                    break;
                }
                case 11: {
                    Object transition = this.serializer.deserializeTransition(this.readData(this.serializer.getTransitionSize()));
                    this.writeString(transition.toString());
                    this.outputStream.flush();
                }
            }
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }
}

