/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.io.File;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.fiacre.ConcreteContextEnvFactory;
import obp.explorer.runtime.obs.AtomicAction;

public class BFSExplorer
extends AbstractExplorer {
    Queue<Configuration> toSee;
    Map<Configuration, Configuration> finalConfigurations = null;

    public static int getExplorerID() {
        return 0;
    }

    public BFSExplorer(ProgramLoader programLoader) {
        this(programLoader, (ConcreteContext)null, (File)null);
    }

    public BFSExplorer(ProgramLoader programLoader, ConcreteContext context, File ccsl) {
        super(programLoader, context, ccsl, context == null ? null : new ConcreteContextEnvFactory(context));
    }

    @Override
    public void initializeExploration() {
        this.toSee = new ArrayDeque<Configuration>();
        this.finalConfigurations = new HashMap<Configuration, Configuration>();
        super.initializeExploration();
    }

    @Override
    public boolean atEnd() {
        return this.toSee.isEmpty();
    }

    @Override
    public Configuration nextConfiguration() {
        return this.toSee.remove();
    }

    @Override
    protected void onNewConfiguration(Configuration newConfiguration) {
        this.toSee.add(newConfiguration);
        if (this.finalConfigurations != null) {
            this.finalConfigurations.put(newConfiguration, newConfiguration);
        }
    }

    @Override
    protected void onExistingConfiguration(Configuration configuration) {
    }

    @Override
    protected void onRegisterActionAndTarget(Configuration source, List<AtomicAction> actions2, Configuration target) {
        if (this.finalConfigurations == null) {
            return;
        }
        if (source.id != target.id || actions2.size() > 0) {
            this.finalConfigurations.remove(source);
        }
    }

    @Override
    public void endExploration() {
        if (this.finalConfigurations != null) {
            int[] finalConfigurationIds = new int[this.finalConfigurations.size()];
            int i = 0;
            for (Configuration finalConf : this.finalConfigurations.keySet()) {
                finalConfigurationIds[i++] = finalConf.id;
            }
            this.results.setFinalConfigurations(finalConfigurationIds);
        }
        super.endExploration();
    }
}

