/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.xml.ast;

import java.util.Objects;

public class XmlName
implements Cloneable {
    private final String prefix;
    private final String local;

    public XmlName(String name) {
        int index = name.indexOf(58);
        if (index < 0) {
            this.prefix = null;
            this.local = name;
        } else {
            this.prefix = name.substring(0, index);
            this.local = name.substring(index + 1, name.length());
        }
    }

    public String getLocal() {
        return this.local;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualified() {
        return this.toXmlString();
    }

    public String toString() {
        return super.toString() + " (" + this.toXmlString() + ")";
    }

    public String toXmlString() {
        StringBuffer buffer = new StringBuffer();
        this.writeTo(buffer);
        return buffer.toString();
    }

    public void writeTo(StringBuffer buffer) {
        if (this.prefix != null) {
            buffer.append(this.prefix).append(':');
        }
        buffer.append(this.local);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XmlName other = (XmlName)obj;
        return Objects.equals(this.prefix, other.prefix) && this.local.equals(other.local);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.local);
    }
}

