/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Assignment;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.SingleAssignment;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class DeterministicAssignment
extends Assignment
implements BoostObject {
    private final List<SingleAssignment> assignmentList = new ArrayList<SingleAssignment>();

    public DeterministicAssignment() {
    }

    protected DeterministicAssignment(Boost boost) {
        super(boost);
        for (SingleAssignment oneChild : BoostUtil.readObjectList((Boost)boost, SingleAssignment.class)) {
            this.assignmentList.add(oneChild);
        }
    }

    public List<SingleAssignment> getAssignmentList() {
        return Collections.unmodifiableList(this.assignmentList);
    }

    public int getAssignmentCount() {
        return this.assignmentList.size();
    }

    public SingleAssignment getAssignment(int index) {
        if (index < 0 || index >= this.getAssignmentCount()) {
            return null;
        }
        return this.assignmentList.get(index);
    }

    public void addAssignment(SingleAssignment newValue) {
        this.addAssignment(this.getAssignmentCount(), newValue);
    }

    public void addAssignment(int index, SingleAssignment newValue) {
        this.assignmentList.add(index, newValue);
    }

    public SingleAssignment setAssignment(int index, SingleAssignment newValue) {
        return this.assignmentList.set(index, newValue);
    }

    public void addAllAssignment(Collection<SingleAssignment> toAddList) {
        for (SingleAssignment newValue : toAddList) {
            this.addAssignment(this.getAssignmentCount(), newValue);
        }
    }

    public void removeAssignment(SingleAssignment value) {
        int index = this.assignmentList.indexOf(value);
        if (index >= 0) {
            this.removeAssignment(index);
        }
    }

    public void removeAssignment(int index) {
        this.assignmentList.remove(index);
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.assignmentList);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitDeterministicAssignment(this);
    }
}

