/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.types.IConfigurationMap;

public class DBMConfigurationMap
implements IConfigurationMap {
    Map<Configuration, List<short[]>> configurations = new HashMap<Configuration, List<short[]>>();
    Map<Configuration, Integer> ids = new HashMap<Configuration, Integer>();
    int size = 0;
    static long nbInclusions = 0L;

    @Override
    public Configuration get(Configuration conf) {
        List<short[]> entry = this.configurations.get(conf);
        if (entry == null) {
            return null;
        }
        for (short[] registeredDBM : entry) {
            if (!DBM.inclusion(conf.dbm, registeredDBM)) continue;
            conf.dbm = registeredDBM;
            conf.id = this.ids.get(conf);
            ++nbInclusions;
            return conf;
        }
        return null;
    }

    @Override
    public void put(Configuration conf) {
        List<short[]> entry = this.configurations.get(conf);
        if (entry == null) {
            entry = new ArrayList<short[]>();
            this.configurations.put(conf, entry);
            this.ids.put(conf, conf.id);
        }
        entry.add(conf.dbm);
        ++this.size;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Set<Configuration> getConfigurations() {
        return this.configurations.keySet();
    }

    public long getInclusions() {
        return nbInclusions;
    }

    @Override
    public void clear() {
        nbInclusions = 0L;
        this.size = 0;
        this.configurations.clear();
    }
}

