/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.fiacre;

import java.lang.reflect.Field;
import java.util.Stack;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.matcher.ArrayMatcher;
import obp.explorer.runtime.matcher.ClassMatcher;
import obp.explorer.runtime.matcher.ComposedMatcher;
import obp.explorer.runtime.matcher.ConstantMatcher;
import obp.explorer.runtime.matcher.FieldMatcher;
import obp.explorer.runtime.matcher.Matcher;
import obp.explorer.runtime.matcher.TrueMatcher;
import obp.explorer.runtime.util.NameUtil;
import obp.literal.AnyLiteral;
import obp.literal.ArrayLiteral;
import obp.literal.BooleanLiteral;
import obp.literal.ConstantReference;
import obp.literal.IntegerLiteral;
import obp.literal.Literal;
import obp.literal.LiteralField;
import obp.literal.LiteralVisitor;
import obp.literal.RecordLiteral;
import obp.literal.StringLiteral;
import obp.literal.UnionLiteral;
import org.xid.basics.error.DiagnosticUtil;

public class LiteralToMatcher
implements LiteralVisitor {
    private final ExplorationContext context;
    private final Stack<Matcher> matcherStack = new Stack();

    public static Matcher toMatcher(Literal literal, ExplorationContext context) {
        LiteralToMatcher transformer = new LiteralToMatcher(context);
        literal.accept(transformer);
        return transformer.matcherStack.pop();
    }

    private LiteralToMatcher(ExplorationContext context) {
        this.context = context;
    }

    @Override
    public void visitAnyLiteral(AnyLiteral toVisit) {
        this.matcherStack.push(new TrueMatcher(this.context));
    }

    @Override
    public void visitStringLiteral(StringLiteral toVisit) {
        this.matcherStack.push(new ConstantMatcher(this.context, toVisit.getValue()));
    }

    @Override
    public void visitBooleanLiteral(BooleanLiteral toVisit) {
        this.matcherStack.push(new ConstantMatcher(this.context, toVisit.isValue()));
    }

    @Override
    public void visitIntegerLiteral(IntegerLiteral toVisit) {
        this.matcherStack.push(new ConstantMatcher(this.context, toVisit.getValue()));
    }

    @Override
    public void visitConstantReference(ConstantReference toVisit) {
        try {
            Class<?> programClass = this.context.getProgram().getClass();
            Field field = programClass.getField(NameUtil.capName(toVisit.getName()));
            this.matcherStack.push(new ConstantMatcher(this.context, field.get(null)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Constant '" + toVisit.getName() + "' doesn't exist.");
        }
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral toVisit) {
        Matcher[] children = new Matcher[toVisit.getValueCount()];
        for (int i = 0; i < toVisit.getValueCount(); ++i) {
            toVisit.getValue(i).accept(this);
            children[i] = new ArrayMatcher(this.context, i, this.matcherStack.pop());
        }
        ComposedMatcher matcher = new ComposedMatcher(this.context, children);
        this.matcherStack.push(matcher);
    }

    @Override
    public void visitLiteralField(LiteralField toVisit) {
    }

    @Override
    public void visitRecordLiteral(RecordLiteral toVisit) {
        try {
            Class<?> programClass = this.context.getProgram().getClass();
            String packageName = programClass.getPackage().getName();
            String className = packageName + "." + NameUtil.capName(toVisit.getTypeName());
            Class<?> type = programClass.getClassLoader().loadClass(className);
            Matcher[] children = new Matcher[toVisit.getFieldCount() + 1];
            children[0] = new ClassMatcher(this.context, type);
            for (int i = 0; i < toVisit.getFieldCount(); ++i) {
                LiteralField field = toVisit.getField(i);
                field.getValue().accept(this);
                try {
                    String fieldName = NameUtil.uncapName(field.getName());
                    Field javaField = type.getField(fieldName);
                    children[i + 1] = new FieldMatcher(this.context, javaField, this.matcherStack.pop());
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Field '" + field.getName() + "' doesn't exist in type '" + toVisit.getTypeName() + "'.");
                }
            }
            ComposedMatcher matcher = new ComposedMatcher(this.context, children);
            this.matcherStack.push(matcher);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Type '" + toVisit.getTypeName() + "' doesn't exist.");
        }
    }

    @Override
    public void visitUnionLiteral(UnionLiteral toVisit) {
        try {
            Class<?> programClass = this.context.getProgram().getClass();
            String packageName = programClass.getPackage().getName();
            String className = packageName + "." + NameUtil.capName(toVisit.getTypeName());
            Class<?> unionType = programClass.getClassLoader().loadClass(className);
            Class<?> type = null;
            String constrName = NameUtil.capName(toVisit.getName());
            for (Class<?> oneConstrType : unionType.getClasses()) {
                if (!oneConstrType.getSimpleName().equals(constrName)) continue;
                type = oneConstrType;
                break;
            }
            if (type == null) {
                throw new IllegalArgumentException("Constr '" + toVisit.getName() + "' doesn't exist in union '" + toVisit.getTypeName() + "'.");
            }
            Matcher matcher = new ClassMatcher(this.context, type);
            if (toVisit.getValue() != null) {
                toVisit.getValue().accept(this);
                Field javaField = type.getField("value");
                Matcher[] children = new Matcher[]{matcher, new FieldMatcher(this.context, javaField, this.matcherStack.pop())};
                matcher = new ComposedMatcher(this.context, children);
            }
            this.matcherStack.push(matcher);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Type '" + toVisit.getTypeName() + "' doesn't exist.");
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Internal error (" + DiagnosticUtil.createMessage((Throwable)e) + ").");
        }
    }
}

