/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp.dfid;

import java.io.IOException;
import java.rmi.RemoteException;
import tlc2.tool.fp.dfid.FPIntSet;
import tlc2.tool.fp.dfid.MemFPIntSet;

public class MultiFPIntSet
extends FPIntSet {
    private FPIntSet[] sets;
    private int fpbits;

    public MultiFPIntSet(int bits) throws RemoteException {
        int len = 1 << bits;
        this.sets = new FPIntSet[len];
        for (int i = 0; i < len; ++i) {
            this.sets[i] = new MemFPIntSet();
        }
        this.fpbits = 64 - bits;
    }

    @Override
    public final void init(int numThreads, String metadir, String filename) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].init(numThreads, metadir, filename + "_" + i);
        }
    }

    @Override
    public final long size() {
        int sum = 0;
        for (int i = 0; i < this.sets.length; ++i) {
            sum = (int)((long)sum + this.sets[i].size());
        }
        return sum;
    }

    @Override
    public final void setLeveled(long fp) {
        int idx = (int)(fp >>> this.fpbits);
        this.sets[idx].setLeveled(fp);
    }

    @Override
    public final int setStatus(long fp, int status) {
        int idx = (int)(fp >>> this.fpbits);
        return this.sets[idx].setStatus(fp, status);
    }

    @Override
    public final int getStatus(long fp) {
        int idx = (int)(fp >>> this.fpbits);
        return this.sets[idx].getStatus(fp);
    }

    @Override
    public final boolean allLeveled() {
        for (int i = 0; i < this.sets.length; ++i) {
            if (this.sets[i].allLeveled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void close() {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].close();
        }
    }

    @Override
    public final double checkFPs() throws IOException {
        double res = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.sets.length; ++i) {
            res = Math.max(res, this.sets[i].checkFPs());
        }
        return res;
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].exit(cleanup);
        }
    }

    @Override
    public final void beginChkpt() throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].beginChkpt();
        }
    }

    @Override
    public final void commitChkpt() throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].commitChkpt();
        }
    }

    @Override
    public final void recover() throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].recover();
        }
    }

    @Override
    public final void beginChkpt(String filename) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].beginChkpt(filename);
        }
    }

    @Override
    public final void commitChkpt(String filename) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].commitChkpt(filename);
        }
    }

    @Override
    public final void recover(String filename) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].recover(filename);
        }
    }
}

