/*
 * Decompiled with CFR 0.152.
 */
package tuml.interpreter.parsercombinator;

import com.google.common.base.Objects;
import java.util.function.Function;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import tuml.interpreter.parsercombinator.ParserCombinator;

public class ABCDExpressionLanguage
extends ParserCombinator {
    private static ParserCombinator.Parser<Exp> expressionParser;

    public static ParserCombinator.Parser<Object> kw(String s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"(");
        _builder.append((Object)s, "");
        _builder.append((Object)")\\b");
        return ParserCombinator.terminal(_builder.toString());
    }

    public static Object getParser() {
        boolean _equals = Objects.equal(expressionParser, null);
        if (_equals) {
            ParserCombinator.Parser<Object> ident = ParserCombinator.terminal("([A-Za-z_]\\w*)");
            ParserCombinator.Parser<Object> integer = ParserCombinator.terminal("([0-9]+)");
            ParserCombinator.WrappingParser<Exp> expression = new ParserCombinator.WrappingParser<Exp>();
            ParserCombinator.CreatingParser<Var> _create = ident.create(Var.class, new Object[0]);
            ParserCombinator.Parser<Object> _isymb = ParserCombinator.isymb("false");
            ParserCombinator.CreatingParser<False> _create_1 = _isymb.create(False.class, new Object[0]);
            ParserCombinator.Parser<False> _or = _create.or(_create_1);
            ParserCombinator.Parser<Object> _isymb_1 = ParserCombinator.isymb("true");
            ParserCombinator.CreatingParser<True> _create_2 = _isymb_1.create(True.class, new Object[0]);
            ParserCombinator.Parser<True> _or_1 = _or.or(_create_2);
            ParserCombinator.CreatingParser<Int> _create_3 = integer.create(Int.class, new Object[0]);
            ParserCombinator.Parser<Int> _or_2 = _or_1.or(_create_3);
            ParserCombinator.Parser<Object> _isymb_2 = ParserCombinator.isymb("(");
            ParserCombinator.Parser<Object> _then = _isymb_2.then(expression);
            ParserCombinator.Parser<Object> _isymb_3 = ParserCombinator.isymb(")");
            ParserCombinator.Parser<Object> _then_1 = _then.then(_isymb_3);
            ParserCombinator.Parser<Object> primitiveExpression = _or_2.or(_then_1);
            ParserCombinator.Parser<Object> _kw = ABCDExpressionLanguage.kw("not");
            ParserCombinator.Parser<Object> _symb = ParserCombinator.symb("-");
            ParserCombinator.Parser<Object> _or_3 = _kw.or(_symb);
            ParserCombinator.Parser<Object> _symb_1 = ParserCombinator.symb("+");
            ParserCombinator.Parser<Object> _or_4 = _or_3.or(_symb_1);
            ParserCombinator.CreatingParser<UnaryExp> _create_4 = primitiveExpression.create(UnaryExp.class, new Object[0]);
            ParserCombinator.Parser<UnaryExp> _then_2 = _or_4.then(_create_4);
            ParserCombinator.Parser<Object> priority0 = _then_2.or(primitiveExpression);
            ParserCombinator.Parser<Object> _symb_2 = ParserCombinator.symb("*");
            ParserCombinator.Parser<Object> _symb_3 = ParserCombinator.symb("/");
            ParserCombinator.Parser<Object> _or_5 = _symb_2.or(_symb_3);
            ParserCombinator.Parser<Object> _symb_4 = ParserCombinator.symb("%");
            ParserCombinator.Parser<Object> _or_6 = _or_5.or(_symb_4);
            ParserCombinator.Parser<Object> _then_3 = _or_6.then(priority0);
            ParserCombinator.CreatingParser<BinaryExp> _create_5 = _then_3.create(BinaryExp.class, new Object[0]);
            ParserCombinator.Parser _mult = _create_5.mult(0, -1);
            ParserCombinator.Parser<Object> priority1 = priority0.then(_mult);
            ParserCombinator.Parser<Object> _symb_5 = ParserCombinator.symb("+");
            ParserCombinator.Parser<Object> _symb_6 = ParserCombinator.symb("-");
            ParserCombinator.Parser<Object> _or_7 = _symb_5.or(_symb_6);
            ParserCombinator.Parser<Object> _then_4 = _or_7.then(priority1);
            ParserCombinator.CreatingParser<BinaryExp> _create_6 = _then_4.create(BinaryExp.class, new Object[0]);
            ParserCombinator.Parser _mult_1 = _create_6.mult(0, -1);
            ParserCombinator.Parser<Object> priority2 = priority1.then(_mult_1);
            ParserCombinator.Parser<Object> _symb_7 = ParserCombinator.symb("<");
            ParserCombinator.Parser<Object> _symb_8 = ParserCombinator.symb("<=");
            ParserCombinator.Parser<Object> _or_8 = _symb_7.or(_symb_8);
            ParserCombinator.Parser<Object> _symb_9 = ParserCombinator.symb(">");
            ParserCombinator.Parser<Object> _or_9 = _or_8.or(_symb_9);
            ParserCombinator.Parser<Object> _symb_10 = ParserCombinator.symb(">=");
            ParserCombinator.Parser<Object> _or_10 = _or_9.or(_symb_10);
            ParserCombinator.Parser<Object> _then_5 = _or_10.then(priority2);
            ParserCombinator.CreatingParser<BinaryExp> _create_7 = _then_5.create(BinaryExp.class, new Object[0]);
            ParserCombinator.Parser _mult_2 = _create_7.mult(0, -1);
            ParserCombinator.Parser<Object> priority3 = priority2.then(_mult_2);
            ParserCombinator.Parser<Object> _symb_11 = ParserCombinator.symb("==");
            ParserCombinator.Parser<Object> _symb_12 = ParserCombinator.symb("!=");
            ParserCombinator.Parser<Object> _or_11 = _symb_11.or(_symb_12);
            ParserCombinator.Parser<Object> _then_6 = _or_11.then(priority3);
            ParserCombinator.CreatingParser<BinaryExp> _create_8 = _then_6.create(BinaryExp.class, new Object[0]);
            ParserCombinator.Parser _mult_3 = _create_8.mult(0, -1);
            ParserCombinator.Parser<Object> priority4 = priority3.then(_mult_3);
            ParserCombinator.Parser<Object> _kw_1 = ABCDExpressionLanguage.kw("or");
            ParserCombinator.Parser<Object> _kw_2 = ABCDExpressionLanguage.kw("and");
            ParserCombinator.Parser<Object> _or_12 = _kw_1.or(_kw_2);
            ParserCombinator.Parser<Object> _kw_3 = ABCDExpressionLanguage.kw("nor");
            ParserCombinator.Parser<Object> _or_13 = _or_12.or(_kw_3);
            ParserCombinator.Parser<Object> _kw_4 = ABCDExpressionLanguage.kw("nand");
            ParserCombinator.Parser<Object> _or_14 = _or_13.or(_kw_4);
            ParserCombinator.Parser<Object> _kw_5 = ABCDExpressionLanguage.kw("xor");
            ParserCombinator.Parser<Object> _or_15 = _or_14.or(_kw_5);
            ParserCombinator.Parser<Object> _then_7 = _or_15.then(priority4);
            ParserCombinator.CreatingParser<BinaryExp> _create_9 = _then_7.create(BinaryExp.class, new Object[0]);
            ParserCombinator.Parser _mult_4 = _create_9.mult(0, -1);
            ParserCombinator.Parser<Object> priority5 = priority4.then(_mult_4);
            expression.set(priority5);
            expressionParser = expression;
        }
        return expressionParser;
    }

    @Data
    public static class BinaryExp
    extends Exp {
        private final Exp left;
        private final String op;
        private final Exp right;

        @Override
        public Object eval(Function<String, Object> env) {
            Comparable<Boolean> _switchResult = null;
            String op = this.op;
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)op, (Object)"or")) {
                _matched = true;
                boolean _or = false;
                Object _eval = this.left.eval(env);
                if (((Boolean)_eval).booleanValue()) {
                    _or = true;
                } else {
                    Object _eval_1 = this.right.eval(env);
                    _or = (Boolean)_eval_1;
                }
                _switchResult = _or;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"and")) {
                _matched = true;
                boolean _and = false;
                Object _eval_2 = this.left.eval(env);
                if (!((Boolean)_eval_2).booleanValue()) {
                    _and = false;
                } else {
                    Object _eval_3 = this.right.eval(env);
                    _and = (Boolean)_eval_3;
                }
                _switchResult = _and;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"==")) {
                _matched = true;
                Object _eval_4 = this.left.eval(env);
                Object _eval_5 = this.right.eval(env);
                _switchResult = Objects.equal((Object)_eval_4, (Object)_eval_5);
            }
            if (!_matched && Objects.equal((Object)op, (Object)"!=")) {
                Object _eval_7;
                _matched = true;
                Object _eval_6 = this.left.eval(env);
                _switchResult = !Objects.equal((Object)_eval_6, (Object)(_eval_7 = this.right.eval(env)));
            }
            if (!_matched && Objects.equal((Object)op, (Object)"-")) {
                _matched = true;
                Object _eval_8 = this.left.eval(env);
                Object _eval_9 = this.right.eval(env);
                _switchResult = (Integer)_eval_8 - (Integer)_eval_9;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"+")) {
                _matched = true;
                Object _eval_10 = this.left.eval(env);
                Object _eval_11 = this.right.eval(env);
                _switchResult = (Integer)_eval_10 + (Integer)_eval_11;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"*")) {
                _matched = true;
                Object _eval_12 = this.left.eval(env);
                Object _eval_13 = this.right.eval(env);
                _switchResult = (Integer)_eval_12 * (Integer)_eval_13;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"/")) {
                _matched = true;
                Object _eval_14 = this.left.eval(env);
                Object _eval_15 = this.right.eval(env);
                _switchResult = (Integer)_eval_14 / (Integer)_eval_15;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"%")) {
                _matched = true;
                Object _eval_16 = this.left.eval(env);
                Object _eval_17 = this.right.eval(env);
                _switchResult = (Integer)_eval_16 % (Integer)_eval_17;
            }
            if (!_matched) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Unsupported binary operator: ");
                _builder.append((Object)this.op, "");
                throw new RuntimeException(_builder.toString());
            }
            return _switchResult;
        }

        public BinaryExp(Exp left, String op, Exp right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinaryExp other = (BinaryExp)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.op == null ? other.op != null : !this.op.equals(other.op)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Exp getLeft() {
            return this.left;
        }

        @Pure
        public String getOp() {
            return this.op;
        }

        @Pure
        public Exp getRight() {
            return this.right;
        }
    }

    @Data
    public static class UnaryExp
    extends Exp {
        private final String op;
        private final Exp operand;

        @Override
        public Object eval(Function<String, Object> env) {
            Comparable<Boolean> _switchResult = null;
            String op = this.op;
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)op, (Object)"not")) {
                _matched = true;
                Object _eval = this.operand.eval(env);
                _switchResult = (Boolean)_eval == false;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"-")) {
                _matched = true;
                Object _eval_1 = this.operand.eval(env);
                _switchResult = -((Integer)_eval_1).intValue();
            }
            if (!_matched && Objects.equal((Object)op, (Object)"+")) {
                _matched = true;
                Object _eval_2 = this.operand.eval(env);
                _switchResult = (Integer)_eval_2;
            }
            if (!_matched) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Unsupported unary operator: ");
                _builder.append((Object)this.op, "");
                throw new RuntimeException(_builder.toString());
            }
            return _switchResult;
        }

        public UnaryExp(String op, Exp operand) {
            this.op = op;
            this.operand = operand;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.operand == null ? 0 : this.operand.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnaryExp other = (UnaryExp)obj;
            if (this.op == null ? other.op != null : !this.op.equals(other.op)) {
                return false;
            }
            return !(this.operand == null ? other.operand != null : !this.operand.equals(other.operand));
        }

        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public String getOp() {
            return this.op;
        }

        @Pure
        public Exp getOperand() {
            return this.operand;
        }
    }

    @Data
    public static class Int
    extends Exp {
        private final int value;

        public String toString() {
            return "" + Integer.valueOf(this.value);
        }

        public Int(String value) {
            int _parseInt;
            this.value = _parseInt = Integer.parseInt(value);
        }

        @Override
        public Object eval(Function<String, Object> env) {
            return this.value;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Int other = (Int)obj;
            return other.value == this.value;
        }

        @Pure
        public int getValue() {
            return this.value;
        }
    }

    @Data
    public static class Var
    extends Exp {
        private final String name;

        public String toString() {
            return this.name;
        }

        @Override
        public Object eval(Function<String, Object> env) {
            return env.apply(this.name);
        }

        public Var(String name) {
            this.name = name;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Var other = (Var)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Pure
        public String getName() {
            return this.name;
        }
    }

    public static class False
    extends Exp {
        public String toString() {
            return "false";
        }

        @Override
        public Object eval(Function<String, Object> env) {
            return false;
        }
    }

    public static class True
    extends Exp {
        public String toString() {
            return "true";
        }

        @Override
        public Object eval(Function<String, Object> env) {
            return true;
        }
    }

    public static abstract class Exp {
        public abstract Object eval(Function<String, Object> var1);
    }
}

