/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.variable;

import spinja.promela.compiler.parser.ParseException;
import spinja.util.StringWriter;

public class VariableType {
    public static VariableType BIT = new VariableType("bit", "int", 1);
    public static VariableType BOOL = new VariableType("bool", "int", 1);
    public static VariableType BYTE = new VariableType("byte", "int", 8);
    public static VariableType PID = new VariableType("pid", "int", 8);
    public static VariableType SHORT = new VariableType("short", "int", 16);
    public static VariableType INT = new VariableType("int", "int", 32);
    public static VariableType MTYPE = new VariableType("mtype", "int", 8){

        @Override
        public boolean canConvert(VariableType variableType) {
            return variableType == MTYPE;
        }
    };
    private final String name;
    private final String javaName;
    private final int bits;

    protected VariableType(String string, String string2, int n) {
        this.name = string;
        this.javaName = string2;
        this.bits = n;
    }

    public boolean canConvert(VariableType variableType) {
        return variableType == BIT || variableType == BOOL || variableType == BYTE || variableType == PID || variableType == SHORT || variableType == INT;
    }

    public void generateClass(StringWriter stringWriter) {
    }

    public int getBits() {
        return this.bits;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getMask() {
        if (this.bits >= 32) {
            return null;
        }
        return "0x" + Integer.toHexString((1 << this.bits) - 1);
    }

    public int getMaskInt() {
        if (this.bits >= 32) {
            return -1;
        }
        return (1 << this.bits) - 1;
    }

    public String getName() {
        return this.name;
    }

    public void writeVariableClass(StringWriter stringWriter) throws ParseException {
    }
}

