/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.xml.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.petitparser.grammar.xml.ast.XmlAttribute;
import org.petitparser.grammar.xml.ast.XmlDocument;

public abstract class XmlNode
implements Iterable<XmlNode> {
    private XmlNode parent;

    public XmlNode getParent() {
        return this.parent;
    }

    void setParent(XmlNode parent) {
        this.parent = parent;
    }

    public List<XmlAttribute> getAttributes() {
        return Collections.emptyList();
    }

    public List<XmlNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Iterator<XmlNode> iterator() {
        ArrayList<XmlNode> nodes = new ArrayList<XmlNode>();
        this.allAllNodesTo(nodes);
        return nodes.iterator();
    }

    private void allAllNodesTo(List<XmlNode> nodes) {
        nodes.add(this);
        nodes.addAll(this.getAttributes());
        for (XmlNode node : this.getChildren()) {
            node.allAllNodesTo(nodes);
        }
    }

    public XmlNode getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public XmlDocument getDocument() {
        return this.parent == null ? null : this.parent.getDocument();
    }

    public final XmlNode getFirstChild() {
        List<XmlNode> children = this.getChildren();
        return children.size() > 0 ? children.get(0) : null;
    }

    public final XmlNode getLastChild() {
        List<XmlNode> children = this.getChildren();
        return children.size() > 0 ? children.get(children.size() - 1) : null;
    }

    public final XmlNode getNextSibling() {
        XmlNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        List<XmlNode> children = parent.getChildren();
        for (int i = 0; i < children.size() - 1; ++i) {
            if (children.get(i) != this) continue;
            return children.get(i + 1);
        }
        return null;
    }

    public final XmlNode getPreviousSibling() {
        XmlNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        List<XmlNode> children = parent.getChildren();
        for (int i = 1; i < children.size(); ++i) {
            if (children.get(i) != this) continue;
            return children.get(i - 1);
        }
        return null;
    }

    public String toString() {
        return super.toString() + " (" + this.toXmlString() + ")";
    }

    public String toXmlString() {
        StringBuffer buffer = new StringBuffer();
        this.writeTo(buffer);
        return buffer.toString();
    }

    public abstract void writeTo(StringBuffer var1);
}

