/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.expression.CompoundExpression;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.expression.Identifier;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.Variable;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.util.StringWriter;

public class ChannelSendAction
extends Action
implements CompoundExpression {
    private final Variable var;
    private final List<Expression> exprs;

    public ChannelSendAction(Token token, Variable variable) {
        super(token);
        this.var = variable;
        this.exprs = new ArrayList<Expression>();
    }

    @Override
    public void addExpression(Expression expression) {
        this.exprs.add(expression);
        for (VariableAccess variableAccess : expression.readVariables()) {
            variableAccess.getVar().setRead(true);
        }
    }

    @Override
    public String getEnabledExpression() {
        return this.var + " != -1 && !_channels[" + this.var + "].isRendezVous() && _channels[" + this.var + "].canSend()";
    }

    @Override
    public boolean isLocal(Proctype proctype) {
        if (!proctype.isXS(this.var)) {
            return false;
        }
        for (Expression expression : this.exprs) {
            for (VariableAccess variableAccess : expression.readVariables()) {
                if (proctype.hasVariable(variableAccess.getVar().getName())) continue;
                return false;
            }
        }
        return super.isLocal(proctype);
    }

    @Override
    public void printExtraFunctions(StringWriter stringWriter) {
        stringWriter.appendLine("public int[] getRendezvous() {");
        stringWriter.indent();
        stringWriter.appendLine("if(!_channels[", this.var, "].isRendezVous()) return null;");
        stringWriter.appendPrefix().append("return new int[]{").append(this.var);
        for (Expression expression : this.exprs) {
            stringWriter.append(", ").append(expression.toString());
        }
        stringWriter.append("};").appendPostfix();
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
    }

    @Override
    public void printTakeStatement(StringWriter stringWriter) throws ParseException {
        stringWriter.appendPrefix().append("_channels[").append(this.var).append("].send(");
        for (Expression expression : this.exprs) {
            stringWriter.append(expression.getIntExpression()).append(", ");
        }
        stringWriter.setLength(stringWriter.length() - 2);
        stringWriter.append(");").appendPostfix();
    }

    public List<Identifier> getChangedVariables() {
        return Collections.emptyList();
    }

    @Override
    public void printUndoStatement(StringWriter stringWriter) {
        stringWriter.appendLine("_channels[", this.var, "].readLast();");
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(this.var.getName()).append("!");
        for (Expression expression : this.exprs) {
            stringWriter.append(expression.toString()).append(",");
        }
        stringWriter.setLength(stringWriter.length() - 1);
        return stringWriter.toString();
    }
}

