/*
 * Decompiled with CFR 0.152.
 */
package spinja.options;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import spinja.options.Option;

public class OptionParser {
    private final SortedMap<Character, Option> options = new TreeMap<Character, Option>();
    private final List<String> files = new ArrayList<String>();
    private final String programName;
    private final String shortDescr;
    private final String moreInfo;
    private final boolean acceptsOtherOptions;

    public OptionParser(String string, String string2, String string3, boolean bl) {
        this.acceptsOtherOptions = bl;
        this.moreInfo = string3;
        this.shortDescr = string2;
        this.programName = string;
    }

    public void addOption(Option option) throws IllegalArgumentException {
        if (this.options.containsKey(Character.valueOf(option.getChar()))) {
            throw new IllegalArgumentException("There already exists an option with the letter " + option.getChar());
        }
        this.options.put(Character.valueOf(option.getChar()), option);
    }

    public List<String> getFiles() {
        return new ArrayList<String>(this.files);
    }

    public void parse(String[] stringArray) {
        String string;
        int n;
        System.out.println(this.shortDescr + "\n");
        for (n = 0; n < stringArray.length && (string = stringArray[n]).startsWith("-") && string.length() > 1; ++n) {
            char c = string.charAt(1);
            Option option = (Option)this.options.get(Character.valueOf(c));
            if (option == null) {
                if (c != '?') {
                    System.out.println("Option not recognized: " + string);
                }
                this.printUsage();
            }
            option.parseOption(string.substring(2));
        }
        if (n < stringArray.length) {
            if (this.acceptsOtherOptions) {
                while (n < stringArray.length) {
                    this.files.add(stringArray[n]);
                    ++n;
                }
            } else {
                System.out.print("Extra arguments are given, but none are suspected: ");
                while (n < stringArray.length) {
                    System.out.print(stringArray[n]);
                    System.out.print(" ");
                    ++n;
                }
                System.out.println();
                this.printUsage();
            }
        }
    }

    public void printUsage() {
        System.out.println();
        System.out.println(this.moreInfo);
        System.out.println();
        System.out.println("Usage: " + this.programName + " [options] " + (this.acceptsOtherOptions ? "filename" : ""));
        System.out.println();
        for (Option option : this.options.values()) {
            System.out.println(option.toString());
        }
        System.out.println();
        System.exit(-1);
    }
}

