/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.simulation;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.simulation.GlobalNondeterministicSimulator;
import obp.explorer.runtime.simulation.ITransitionSelectionPolicy;
import obp.explorer.runtime.simulation.SimulationResult;
import obp.explorer.runtime.simulation.Simulator;
import obp.explorer.runtime.types.IConfigurationMap;
import obp.result.FinalState;

public class InteractiveSimulator
extends GlobalNondeterministicSimulator {
    public Configuration currentConfiguration = null;
    protected List<Transition> reallyFireable = new ArrayList<Transition>();
    private List<Action> actionsList = new ArrayList<Action>();
    Map<Transition, Action> possibleActions = null;
    Transition currentTransition;
    SimulationResult simResult = new SimulationResult();
    GlobalNondeterministicSimulator tester;

    @Override
    protected Object clone() throws CloneNotSupportedException {
        InteractiveSimulator theClone = (InteractiveSimulator)super.clone();
        theClone.reallyFireable = this.reallyFireable == null ? null : new ArrayList<Transition>(this.reallyFireable);
        theClone.actionsList = this.actionsList == null ? null : new ArrayList<Action>(this.actionsList);
        theClone.possibleActions = this.possibleActions == null ? null : new HashMap<Transition, Action>(this.possibleActions);
        return theClone;
    }

    public InteractiveSimulator(ProgramLoader programLoader) {
        this(programLoader, null);
    }

    public InteractiveSimulator(ProgramLoader programLoader, ConcreteContext context) {
        this(programLoader, context, (ITransitionSelectionPolicy)null);
    }

    public InteractiveSimulator(ProgramLoader programLoader, ConcreteContext context, ITransitionSelectionPolicy policy) {
        super(programLoader, context, policy);
        this.isForcedSynchronization = true;
    }

    public void start() {
        this.initializeExploration();
        this.currentConfiguration = (Configuration)this.toSee.peek();
        this.behaviorCount = this.getProcessBehaviorCount();
    }

    public boolean hasNext() {
        return this.toSee != null && !this.toSee.isEmpty();
    }

    public SimulationResult nextRandom() {
        if (this.currentConfiguration == null) {
            return null;
        }
        if (!this.hasNext()) {
            return null;
        }
        this.currentConfiguration = (Configuration)this.toSee.remove();
        List<Transition> fired = this.simulate(this.currentConfiguration, this.reallyFireable);
        this.saveConfiguration(this.currentConfiguration);
        if (!this.hasNext()) {
            this.endExploration();
            return this.simResult.setResult(this.results);
        }
        return this.simResult.setFiredTransitions(fired);
    }

    public SimulationResult toEndRandom() {
        if (this.currentConfiguration == null) {
            return null;
        }
        while (this.hasNext()) {
            this.currentConfiguration = (Configuration)this.toSee.remove();
            this.simulate(this.currentConfiguration, this.getReallyFireable());
            this.saveConfiguration(this.currentConfiguration);
        }
        this.endExploration();
        return this.simResult.setResult(this.results);
    }

    public SimulationResult nextWith(Transition transition) {
        if (this.currentConfiguration == null) {
            return null;
        }
        if (!this.hasNext()) {
            return null;
        }
        this.currentConfiguration = (Configuration)this.toSee.remove();
        ArrayList<Transition> toFire = new ArrayList<Transition>();
        toFire.add(transition);
        this.fireTransitions(this.currentConfiguration, this.reallyFireable, toFire);
        this.actionsList.add(this.possibleActions.get(transition));
        this.saveConfiguration(this.currentConfiguration);
        if (!this.hasNext()) {
            this.results.setConfigurationCount(BigInteger.valueOf(this.getConfigurationCount()));
            this.results.setActionCount(this.getActionCount());
            this.results.setState(FinalState.Complete);
            return this.simResult.setResult(this.results);
        }
        return this.simResult.setFiredTransitions(toFire);
    }

    public Configuration getCurrentConfigurationId() {
        return this.currentConfiguration;
    }

    @Override
    public void registerActionAndTarget(Configuration source, List<AtomicAction> actions2, Configuration target) {
        super.registerActionAndTarget(source, actions2, target);
    }

    public String transitionString(Transition transition) {
        return this.possibleActions.get(transition).toFancyString(this.symbols);
    }

    public List<Transition> getReallyFireable() {
        if (!this.hasNext()) {
            return null;
        }
        try {
            this.tester = (GlobalNondeterministicSimulator)((Simulator)this).clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        List<Transition> theFireable = this.getFireable((Configuration)this.toSee.peek());
        this.possibleActions = new IdentityHashMap<Transition, Action>();
        this.reallyFireable = new ArrayList<Transition>();
        for (Transition transition : theFireable) {
            ArrayList<Transition> toFire = new ArrayList<Transition>();
            toFire.add(transition);
            if (!this.tester.fireTransitions((Configuration)this.toSee.peek(), theFireable, toFire)) continue;
            this.reallyFireable.add(transition);
            Action action = this.tester.localActionList.size() < 1 ? new Action(Collections.<AtomicAction>emptyList(), 0) : (Action)this.tester.localActionList.get(0);
            this.possibleActions.put(transition, action);
            this.tester.localActionList.clear();
        }
        return this.reallyFireable;
    }

    public IConfigurationMap getKnown() {
        return this.known;
    }

    public Queue<Configuration> getToSee() {
        return this.toSee;
    }

    public SymbolsTable getSymbols() {
        return this.symbols;
    }

    public List<Action> getAction() {
        return this.actionsList;
    }

    public Behavior[] getBehavior() {
        return this.behaviors;
    }

    public Configuration getNextConfiguration() {
        return (Configuration)this.toSee.peek();
    }
}

