/*
 * Decompiled with CFR 0.152.
 */
package spinja.store;

import java.util.Arrays;
import spinja.store.StateStore;
import spinja.store.hash.HashAlgorithm;

public class LinkedHashTable
extends StateStore {
    private final Bucket[] table;
    private int collisions;
    private int stored;
    private long bytes;
    private final HashAlgorithm hash;
    private final int mask;

    public LinkedHashTable(int n, HashAlgorithm hashAlgorithm) {
        if (n <= 0 || n > 31) {
            throw new IllegalArgumentException("The size should always be between 1 and 31");
        }
        this.table = new Bucket[1 << n];
        this.collisions = 0;
        this.stored = 0;
        this.hash = hashAlgorithm;
        this.mask = (1 << n) - 1;
        this.bytes = 40 + 4 * this.table.length;
    }

    @Override
    public int addState(byte[] byArray) {
        int n = this.hash.hash(byArray, 0) & this.mask;
        Bucket bucket = this.table[n];
        if (bucket == null) {
            this.table[n] = new Bucket(byArray);
            this.bytes += (long)(32 + byArray.length >> 3 << 3);
            ++this.stored;
        } else {
            int n2 = 0;
            while (bucket.next != null) {
                if (Arrays.equals(bucket.content, byArray)) {
                    return -n - 1;
                }
                ++n2;
                bucket = bucket.next;
            }
            if (Arrays.equals(bucket.content, byArray)) {
                return -n - 1;
            }
            bucket.next = new Bucket(byArray);
            this.bytes += (long)(32 + byArray.length >> 3 << 3);
            this.collisions += n2;
            ++this.stored;
        }
        return n;
    }

    @Override
    public long getBytes() {
        return this.bytes;
    }

    @Override
    public void printSummary() {
        System.out.printf("hash conflicts: %d (resolved)\n", this.collisions);
        System.out.println();
    }

    @Override
    public int getStored() {
        return this.stored;
    }

    private class Bucket {
        Bucket next;
        final byte[] content;

        Bucket(byte[] byArray) {
            this.content = byArray;
            this.next = null;
        }
    }
}

