/*
 * Decompiled with CFR 0.152.
 */
package plug.language.tuml.simulation.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.xtext.xbase.lib.Pair;
import tuml.interpreter.ActiveObject;

public class TransitionTreeGenerator {
    public static TreeNode generateTree(Pair<ActiveObject, Transition> fireable) {
        DefaultMutableTreeNode treeN = new DefaultMutableTreeNode(fireable.getKey());
        Transition transition = (Transition)fireable.getValue();
        treeN.add(new DefaultMutableTreeNode("source: " + transition.getSource().getName()));
        treeN.add(new DefaultMutableTreeNode("target: " + transition.getTarget().getName()));
        if (!transition.getTriggers().isEmpty()) {
            DefaultMutableTreeNode triggers = new DefaultMutableTreeNode("triggers");
            treeN.add(triggers);
            for (Trigger trigger : transition.getTriggers()) {
                if (!(trigger.getEvent() instanceof SignalEvent)) continue;
                triggers.add(new DefaultMutableTreeNode(((SignalEvent)trigger.getEvent()).getSignal().getName()));
            }
        }
        if (transition.getGuard() != null) {
            String guard = (String)((OpaqueExpression)transition.getGuard().getSpecification()).getBodies().get(0);
            treeN.add(new DefaultMutableTreeNode("[" + guard + "]"));
        }
        return treeN;
    }
}

