/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import obp.cc.ConcreteContext;
import obp.explorer.ExplorerResult;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.Component;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.Program;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.ccsl.CCSLBehavior;
import obp.explorer.runtime.ccsl.CCSLConfigurationGraph;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.evaluator.Evaluator;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.fiacre.ConcreteContextEnvFactory;
import obp.explorer.runtime.fiacre.PredicateToEvaluator;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.obs.ObsBehavior;
import obp.explorer.runtime.util.ActionUtil;
import obp.explorer.runtime.util.ConfigurationUtil;
import obp.predicate.Predicate;
import obp.predicate.SystemAccess;
import obp.util.PredicateUtil;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.JBoost;

public class ConfsFileHandler
implements ExplorationContext {
    private final ExplorerResult explorerResult;
    private Program program;
    private Behavior[] behaviors;
    private Tester[] asserts;
    private Channel[] channels;
    private SymbolsTable symbols;
    private JBoost boost;
    private int configurationCount = -1;
    private int actionCount;
    protected Configuration lastReadConfiguration;
    protected List<Action> lastReadActions;
    private List<Configuration> configurations;
    private List<List<Action>> actions;

    public ConfsFileHandler(ExplorerResult explorerResult) throws Exception {
        this.explorerResult = explorerResult;
        this.init();
    }

    public ConfsFileHandler(ProgramLoader programLoader, File resultFile) throws Exception {
        this(programLoader, null, null, resultFile);
    }

    public ConfsFileHandler(ProgramLoader programLoader, ConcreteContext context, File resultFile) throws Exception {
        this(new ExplorerResult(programLoader, context, null, resultFile));
    }

    public ConfsFileHandler(ProgramLoader programLoader, ConcreteContext context, File ccslFile, File resultFile) throws Exception {
        this(new ExplorerResult(programLoader, context, ccslFile, resultFile));
    }

    private void init() throws Exception {
        ProgramLoader programLoader = this.explorerResult.getProgramLoader();
        this.program = programLoader.loadProgram();
        if (this.program == null) {
            return;
        }
        this.configurations = new ArrayList<Configuration>();
        this.actions = new ArrayList<List<Action>>();
        this.symbols = SymbolsTable.createInstance();
        Component root = this.program.getRoot(this.symbols);
        this.computeProgram(root);
        if (this.explorerResult.getResultFile() == null) {
            return;
        }
        this.boost = new JBoost("Explorer", 1, programLoader.getClassLoader());
        try {
            try {
                new ZipFile(this.explorerResult.getResultFile());
                ZipInputStream stream = new ZipInputStream(new FileInputStream(this.explorerResult.getResultFile()));
                this.boost.initializeZippedReading(stream, "configurations.txt");
            }
            catch (ZipException ze) {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.explorerResult.getResultFile()));
                this.boost.initializeReading((InputStream)stream);
            }
            this.configurationCount = 0;
            this.actionCount = 0;
            this.configurations = new ArrayList<Configuration>();
            this.actions = new ArrayList<List<Action>>();
            this.readOnce(true);
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't read confs file '" + this.explorerResult.getResultFile().getPath() + "'.");
            return;
        }
    }

    private void computeProgram(Component root) {
        Object env;
        ConcreteContextEnvFactory envFactory = null;
        if (this.explorerResult.getContext() != null) {
            envFactory = new ConcreteContextEnvFactory(this.explorerResult.getContext());
        }
        ArrayList<Behavior> behaviorList = new ArrayList<Behavior>();
        root.collectBehaviors(behaviorList);
        this.symbols.endOfBehaviors();
        if (this.explorerResult.getCCSLFile() != null) {
            CCSLBehavior ccsl = new CCSLBehavior(new CCSLConfigurationGraph(this.explorerResult.getCCSLFile()), this.symbols);
            behaviorList.add(ccsl);
            this.symbols.endOfBehaviors();
        }
        if (envFactory != null) {
            ObsBehavior[] obsBehaviors;
            env = envFactory.createEnv(this, this.symbols);
            if (env != null) {
                behaviorList.add((Behavior)env);
                this.symbols.endOfBehaviors();
            }
            if ((obsBehaviors = envFactory.createObservers(this, this.symbols)) != null) {
                for (ObsBehavior obsBehavior : obsBehaviors) {
                    behaviorList.add(obsBehavior);
                }
            }
        }
        this.behaviors = new Behavior[behaviorList.size()];
        env = behaviorList.iterator();
        while (env.hasNext()) {
            Behavior process;
            this.behaviors[process.id] = process = (Behavior)env.next();
        }
        this.asserts = envFactory != null ? envFactory.createAsserts(this, this.symbols) : new Tester[0];
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        root.collectChannels(channelList);
        this.channels = new Channel[channelList.size()];
        Iterator iterator = channelList.iterator();
        while (iterator.hasNext()) {
            Channel channel;
            this.channels[channel.id] = channel = (Channel)iterator.next();
        }
        for (Behavior process : behaviorList) {
            process.link(this, this.symbols);
        }
    }

    void doOnConfiguration(Configuration conf, List<Action> newActions) {
        this.configurations.add(conf);
        this.actions.add(newActions);
    }

    synchronized boolean readOnce(boolean init) {
        if (!init && this.lastReadConfiguration == null) {
            return false;
        }
        this.lastReadConfiguration = ConfigurationUtil.read((Boost)this.boost, this.behaviors);
        this.lastReadActions = ActionUtil.readList((Boost)this.boost);
        if (this.lastReadConfiguration != null) {
            this.doOnConfiguration(this.lastReadConfiguration, this.lastReadActions);
            ++this.configurationCount;
            this.actionCount += this.lastReadActions.size();
        } else {
            this.boost.close();
            this.boost = null;
        }
        return this.lastReadConfiguration != null;
    }

    public boolean readOnce() {
        return this.readOnce(false);
    }

    public int readAll() {
        while (this.readOnce(false)) {
        }
        return this.configurationCount;
    }

    public void close() {
        if (this.boost != null) {
            this.boost.close();
        }
    }

    public Configuration getLastReadConfiguration() {
        return this.lastReadConfiguration;
    }

    public List<Action> getLastReadActions() {
        return this.lastReadActions;
    }

    public Configuration getConfiguration(int id) {
        if (id < 0 || this.lastReadActions == null && id > this.configurationCount) {
            return null;
        }
        while (id > this.configurationCount - 1) {
            if (this.readOnce(false)) continue;
            return null;
        }
        return this.configurations.get(id);
    }

    public SymbolsTable getSymbols() {
        return this.symbols;
    }

    public ExplorerResult getExplorerResult() {
        return this.explorerResult;
    }

    public String configurationToString(Configuration configuration) {
        int i;
        int length;
        StringBuilder text = new StringBuilder();
        text.append("config: ");
        text.append(configuration.id);
        text.append(" {\n");
        for (int i2 = 0; i2 < this.behaviors.length; ++i2) {
            text.append("- ");
            text.append(this.behaviors[i2].toStringConfiguration(configuration.behaviorConfigurations[i2]));
            text.append("\n");
        }
        if (configuration.dbm != null) {
            text.append("- time: ");
            text.append(DBM.toConstrainString(configuration.dbm));
            text.append("\n");
        }
        if (this.channels.length > 0) {
            text.append("- channels: ");
            length = text.length();
            for (i = 0; i < this.channels.length; ++i) {
                Channel channel = this.channels[i];
                if (text.length() > length) {
                    text.append(", ");
                }
                text.append(channel.name);
                if (channel.clockId < 0) continue;
                text.append("{clock:");
                text.append(channel.clockId);
                text.append("}");
            }
            text.append("\n");
        }
        if (this.asserts.length > 0) {
            text.append("- violated asserts: ");
            length = text.length();
            for (i = 0; i < this.asserts.length; ++i) {
                if (this.asserts[i].test(configuration)) continue;
                if (text.length() > length) {
                    text.append(", ");
                }
                text.append(this.explorerResult.getAssertDescriptions()[i]);
            }
            if (text.length() == length) {
                text.append("none");
            }
            text.append("\n");
        }
        text.append("}");
        return text.toString();
    }

    public String configurationToDotString(Configuration configuration) {
        StringBuilder text = new StringBuilder();
        text.append(configuration.id);
        text.append("\\n");
        for (int i = 0; i < this.behaviors.length; ++i) {
            text.append(this.behaviors[i].toDotStringConfiguration(configuration.behaviorConfigurations[i]));
            text.append("\\n");
        }
        if (configuration.dbm != null) {
            text.append("Time ");
            text.append(DBM.toConstrainString(configuration.dbm));
            text.append("\\n");
        }
        if (this.channels.length > 0) {
            text.append("- Channels ");
            int length = text.length();
            for (int i = 0; i < this.channels.length; ++i) {
                Channel channel = this.channels[i];
                if (text.length() > length) {
                    text.append(", ");
                }
                text.append(channel.name);
                if (channel.clockId < 0) continue;
                text.append("{clock:");
                text.append(channel.clockId);
                text.append("}");
            }
            text.append("\\n");
        }
        return text.toString();
    }

    public int getConfigurationCount() {
        return this.configurationCount;
    }

    public List<Action> getActionsFrom(int id) {
        if (id < 0 || this.lastReadActions == null && id > this.configurationCount) {
            return null;
        }
        while (id > this.configurationCount - 1) {
            if (this.readOnce(false)) continue;
            return null;
        }
        return this.actions.get(id);
    }

    public String actionToStringForGraph(Action action) {
        return action.toFancyStringForGraph(this.getSymbols());
    }

    public String actionToString(Action action) {
        return action.toFancyString(this.getSymbols());
    }

    public int getActionCount() {
        return this.actionCount;
    }

    public int getClosestPredecessor(int id) {
        if (id <= 0) {
            return -1;
        }
        for (int predecessor = id - 1; predecessor >= 0; --predecessor) {
            for (Action action : this.actions.get(predecessor)) {
                if (action.targetId != id) continue;
                return predecessor;
            }
        }
        return -1;
    }

    public int getFarthestPredecessor(int id) {
        if (id <= 0) {
            return -1;
        }
        for (int predecessor = 0; predecessor < id; ++predecessor) {
            for (Action action : this.actions.get(predecessor)) {
                if (action.targetId != id) continue;
                return predecessor;
            }
        }
        return -1;
    }

    public List<Action> getFastestToComputeTrace(int toId) {
        if (toId <= 0 || toId >= this.getConfigurationCount()) {
            return Collections.emptyList();
        }
        ArrayList<Action> trace = new ArrayList<Action>();
        block0: for (int predecessor = toId - 1; predecessor >= 0; --predecessor) {
            for (Action action : this.actions.get(predecessor)) {
                if (action.targetId != toId) continue;
                toId = predecessor;
                trace.add(action);
                continue block0;
            }
        }
        Collections.reverse(trace);
        return trace;
    }

    public List<Action> getShortestTrace(int toId) {
        if (toId <= 0 || toId >= this.getConfigurationCount()) {
            return Collections.emptyList();
        }
        ArrayList<Action> trace = new ArrayList<Action>();
        while (toId > 0) {
            int predecessor = 0;
            boolean keepGoing = true;
            while (keepGoing) {
                for (Action action : this.actions.get(predecessor)) {
                    if (action.targetId != toId) continue;
                    toId = predecessor;
                    trace.add(action);
                    keepGoing = false;
                    break;
                }
                ++predecessor;
            }
        }
        Collections.reverse(trace);
        return trace;
    }

    public List<Action> getShortestPath(int source, int target) {
        if (source < 0 || source >= this.getConfigurationCount()) {
            return Collections.emptyList();
        }
        if (target < 0 || target >= this.getConfigurationCount()) {
            return Collections.emptyList();
        }
        if (source == target) {
            for (Action action : this.actions.get(source)) {
                if (action.targetId != target) continue;
                return Collections.singletonList(action);
            }
            return Collections.emptyList();
        }
        HashMap<Integer, Integer> predecessors = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> distances = new HashMap<Integer, Integer>();
        HashSet<Integer> visited = new HashSet<Integer>();
        PriorityQueue<Point> candidates = new PriorityQueue<Point>(10, new Comparator<Point>(){

            @Override
            public int compare(Point o1, Point o2) {
                if (o1.y < o2.y) {
                    return -1;
                }
                if (o1.y == o2.y) {
                    return 0;
                }
                return 1;
            }
        });
        distances.put(0, 0);
        candidates.add(new Point(source, 0));
        while (!candidates.isEmpty()) {
            Point current = candidates.poll();
            if (current.x == target) break;
            visited.add(current.x);
            for (Action action : this.actions.get(current.x)) {
                if (visited.contains(action.targetId)) continue;
                int distance = distances.containsKey(current.x) ? (Integer)distances.get(current.x) : Integer.MAX_VALUE;
                if (distances.containsKey(action.targetId) && (Integer)distances.get(action.targetId) <= ++distance) continue;
                distances.put(action.targetId, distance);
                predecessors.put(action.targetId, current.x);
                candidates.add(new Point(action.targetId, distance));
            }
        }
        ArrayList<Action> solution = new ArrayList<Action>();
        int current = target;
        while (predecessors.containsKey(current)) {
            int parent = (Integer)predecessors.get(current);
            for (Action action : this.actions.get(parent)) {
                if (action.targetId != current) continue;
                solution.add(action);
            }
            current = parent;
        }
        Collections.reverse(solution);
        return solution;
    }

    public String toDot(Tester tester, boolean nodeDescription) {
        StringBuilder dot = new StringBuilder();
        dot.append("digraph lts {\n");
        int size = this.actions.size();
        for (int i = 0; i < size; ++i) {
            Configuration configuration = this.configurations.get(i);
            dot.append("\t");
            dot.append(i);
            dot.append(" [");
            if (nodeDescription) {
                dot.append("shape=box, label=\"");
                dot.append(this.configurationToDotString(configuration));
                dot.append("\"");
            } else {
                dot.append("label=\"");
                dot.append(i);
                dot.append("\"");
            }
            if (tester != null && tester.test(configuration)) {
                dot.append(", color=\"steelblue\"");
            }
            dot.append("];\n");
            for (Action action : this.actions.get(i)) {
                dot.append("\t");
                dot.append(i);
                dot.append(" -> ");
                dot.append(action.targetId);
                dot.append(" [label=\"");
                dot.append(this.actionToStringForGraph(action));
                dot.append("\"];\n");
            }
        }
        dot.append("}");
        return dot.toString();
    }

    public String toAut() {
        StringBuilder aut = new StringBuilder();
        aut.append("des(0,");
        aut.append(this.actionCount);
        aut.append(",");
        aut.append(this.configurationCount);
        aut.append(")\n");
        int size = this.actions.size();
        for (int i = 0; i < size; ++i) {
            for (Action action : this.actions.get(i)) {
                aut.append("(");
                aut.append(i);
                aut.append(",\"");
                aut.append(this.actionToStringForGraph(action));
                aut.append("\",");
                aut.append(action.targetId);
                aut.append(")\n");
            }
        }
        return aut.toString();
    }

    public void toMatrixMarket(File file) {
        try {
            BufferedWriter br = new BufferedWriter(new FileWriter(file));
            br.write("%%MatrixMarket matrix coordinate pattern general\n");
            br.write(this.getConfigurationCount() + " " + this.getConfigurationCount() + " " + this.getActionCount() + "\n");
            for (int i = 0; i < this.getConfigurationCount(); ++i) {
                List<Action> actions2 = this.getActionsFrom(i);
                for (Action act : actions2) {
                    br.write(i + 1 + " " + (act.targetId + 1) + "\n");
                }
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Tester createTester(String predicateString) throws Exception {
        Predicate predicate = PredicateUtil.readPredicate(predicateString);
        return this.createTester(predicate);
    }

    public Tester createTester(Predicate predicate) {
        return new Tester(PredicateToEvaluator.toEvaluator(predicate, (ExplorationContext)this, this.symbols));
    }

    public Evaluator createEvaluator(String accessString) throws Exception {
        SystemAccess access = PredicateUtil.readAccess(accessString);
        return this.createEvaluator(access);
    }

    public Evaluator createEvaluator(SystemAccess access) {
        return PredicateToEvaluator.toEvaluator(access, (ExplorationContext)this, this.symbols);
    }

    @Override
    public ConcreteContext getContext() {
        return this.explorerResult.getContext();
    }

    @Override
    public Behavior getBehavior(short id) {
        return this.behaviors[id];
    }

    @Override
    public int getBehaviorCount() {
        return this.behaviors.length;
    }

    @Override
    public int getProcessBehaviorCount() {
        return this.behaviors.length;
    }

    @Override
    public Channel getChannel(short id) {
        return this.channels[id];
    }

    @Override
    public int getChannelCount() {
        return this.channels.length;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public File getCCSLFile() {
        return this.explorerResult.getCCSLFile();
    }
}

