/*
 * Decompiled with CFR 0.152.
 */
package obp.dot.util;

import obp.dot.DotVisitor;
import obp.dot.Edge;
import obp.dot.Graph;
import obp.dot.Node;
import obp.dot.NodeShape;

public class DotPrinter
implements DotVisitor {
    private StringBuilder dot;

    public String toDot(Graph graph) {
        this.dot = new StringBuilder();
        graph.accept(this);
        return this.dot.toString();
    }

    @Override
    public void visit(Graph toVisit) {
        this.dot.append(toVisit.isDirected() ? "digraph " : "graph ");
        this.dot.append("myGraph");
        this.dot.append(" {\n");
        this.dot.append("\n");
        for (Node node : toVisit.getNodeList()) {
            node.accept(this);
        }
        for (Edge edge : toVisit.getEdgeList()) {
            edge.accept(this);
        }
        this.dot.append("}");
    }

    @Override
    public void visit(Node toVisit) {
        boolean needPrint = false;
        needPrint |= toVisit.getLabel() != null;
        needPrint |= toVisit.getColor() != null;
        needPrint |= toVisit.getPeripheries() > 1;
        needPrint |= toVisit.getShape() != NodeShape.ellipse;
        needPrint |= toVisit.getPosition() != null;
        if (needPrint |= toVisit.getLabelPosition() != null) {
            System.out.println("Node '" + toVisit.getId() + "' needs print.");
            this.dot.append("\t");
            this.dot.append(this.printId(toVisit.getId()));
            this.dot.append(" [");
            if (toVisit.getLabel() != null) {
                this.dot.append("label=\"");
                this.dot.append(toVisit.getColor());
                this.dot.append("\";");
            }
            if (toVisit.getColor() != null) {
                this.dot.append("color=");
                this.dot.append(toVisit.getColor());
                this.dot.append(";");
            }
            this.dot.append("];\n");
        }
    }

    @Override
    public void visit(Edge toVisit) {
        this.dot.append("\t");
        this.dot.append(this.printId(toVisit.getSource().getId()));
        this.dot.append(" -> ");
        this.dot.append(this.printId(toVisit.getTarget().getId()));
        this.dot.append(";\n");
    }

    private String printId(String id) {
        if (this.needQuote(id)) {
            return "\"" + id + "\"";
        }
        return id;
    }

    private boolean needQuote(String id) {
        return id.contains(" ");
    }
}

