/*
 * Decompiled with CFR 0.152.
 */
package plug.simulation.ui.fx;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import plug.core.IConfiguration;
import plug.core.execution.IExecutionViewContext;
import plug.core.fx.ConfigurationTreeView;
import plug.simulation.trace_storage.TraceEntry;
import plug.utils.ui.graph.GraphViewModel;

@Deprecated
public class SimulationGraphViewModel
extends GraphViewModel<TraceEntry<IConfiguration, ?>, Object> {
    private final IExecutionViewContext context;
    private boolean allColorsConsumed = false;
    private final List<Color> colors = new ArrayList<Color>(Arrays.stream(Color.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && f.getType() == Color.class).map(f -> {
        try {
            return (Color)f.get(Color.class);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }).filter(Objects::nonNull).filter(Color::isOpaque).filter(color -> color.getSaturation() > 0.2 && color.getSaturation() < 0.7).collect(Collectors.toList()));
    private int colorIndex = 0;
    private final ObservableMap<Object, Integer> configurationCounts = FXCollections.observableHashMap();
    private final Map<Object, Color> colorMap = new HashMap<Object, Color>();

    public SimulationGraphViewModel(IExecutionViewContext context) {
        this.context = context;
        this.getInitialVertices().addListener(this::onInitialChanged);
        this.getEdges().addListener(this::onEdgesChanged);
        this.configurationCounts.addListener(this::onConfigurationCounts);
    }

    public String vertexDescription(TraceEntry<IConfiguration, ?> vertex) {
        return this.context.getConfigurationDescription(vertex.getConfiguration());
    }

    public String edgeDescription(Object edge) {
        return this.context.getActionDescription(edge);
    }

    public Region vertexNode(TraceEntry vertex) {
        ConfigurationTreeView view = new ConfigurationTreeView(this.context);
        view.setShowRoot(false);
        view.setDifferencesMode(ConfigurationTreeView.DifferenceMode.only);
        view.setOther((IConfiguration)vertex.getParentConfiguration());
        view.setConfiguration((IConfiguration)vertex.getConfiguration());
        return view.getRoot().getChildren().isEmpty() ? null : view;
    }

    public boolean vertexIsSink(TraceEntry vertex) {
        IConfiguration configuration = (IConfiguration)vertex.getConfiguration();
        for (Object fireable : this.context.getRuntime().fireableTransitionsFrom((Object)configuration)) {
            if (fireable == null || this.context.getRuntime().fireOneTransition((Object)configuration, fireable) == null) continue;
            return false;
        }
        return true;
    }

    public Color vertexColor(TraceEntry vertex) {
        return this.allColorsConsumed ? Color.WHITE : this.colorMap.getOrDefault(vertex.getConfiguration(), Color.WHITE);
    }

    public Color configurationColor(IConfiguration<?> configuration) {
        if (this.colorMap.containsKey(configuration)) {
            return this.colorMap.get(configuration);
        }
        if ((Integer)this.configurationCounts.getOrDefault(configuration, (Object)0) >= 1) {
            return Color.GRAY;
        }
        return Color.WHITE;
    }

    protected void onInitialChanged(ListChangeListener.Change<? extends TraceEntry> change) {
        change.reset();
        while (change.next()) {
            for (TraceEntry entry : change.getAddedSubList()) {
                this.count(entry.getConfiguration());
            }
            for (TraceEntry traceEntry : change.getRemoved()) {
                this.decount(traceEntry.getConfiguration());
            }
        }
    }

    protected void onEdgesChanged(ListChangeListener.Change<? extends GraphViewModel.Edge<TraceEntry<IConfiguration, ?>, Object>> change) {
        if (!this.allColorsConsumed) {
            change.reset();
            while (change.next()) {
                for (GraphViewModel.Edge pair : change.getAddedSubList()) {
                    this.count(((TraceEntry)pair.target).getConfiguration());
                }
                for (GraphViewModel.Edge pair : change.getRemoved()) {
                    this.decount(((TraceEntry)pair.target).getConfiguration());
                }
            }
        }
    }

    protected void count(Object configuration) {
        this.configurationCounts.put(configuration, (Object)((Integer)this.configurationCounts.getOrDefault(configuration, (Object)0) + 1));
    }

    protected void decount(Object configuration) {
        Integer count = (Integer)this.configurationCounts.getOrDefault(configuration, (Object)0);
        if (count <= 1) {
            this.configurationCounts.remove(configuration);
        } else {
            this.configurationCounts.put(configuration, (Object)(count - 1));
        }
    }

    protected void onConfigurationCounts(MapChangeListener.Change<? extends Object, ? extends Integer> change) {
        if (change.wasAdded()) {
            Color removed;
            Object key = change.getKey();
            if ((Integer)change.getValueAdded() >= 2) {
                if (!this.colorMap.containsKey(key)) {
                    this.newColorForConfiguration(key);
                }
            } else if ((Integer)change.getValueAdded() == 1 && (removed = this.colorMap.remove(key)) != null) {
                this.colors.add(this.colorIndex, removed);
            }
        }
    }

    protected void newColorForConfiguration(Object configuration) {
        if (this.colorIndex < this.colors.size()) {
            this.colorMap.put(configuration, this.colors.get(this.colorIndex));
            ++this.colorIndex;
        } else {
            this.allColorsConsumed = true;
            this.colorMap.clear();
        }
    }

    public Set<TraceEntry<IConfiguration, ?>> equivalentVertices(TraceEntry<IConfiguration, ?> vertex) {
        HashSet equivalent = new HashSet();
        for (TraceEntry entry : this.initialVertices) {
            if (vertex == entry || !entry.getConfiguration().equals(vertex.getConfiguration())) continue;
            equivalent.add(entry);
        }
        for (GraphViewModel.Edge edge : this.edges) {
            if (vertex == edge.target || !((IConfiguration)((TraceEntry)edge.target).getConfiguration()).equals(vertex.getConfiguration())) continue;
            equivalent.add((TraceEntry<IConfiguration, ?>)edge.target);
        }
        return equivalent;
    }
}

