/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.error;

import org.xid.basics.Basics;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.Validator;

public class NumberValidator
extends Validator.Stub<String> {
    public NumberValidator(int level, String message, int style) {
        super(level, message, style);
    }

    public NumberValidator(Diagnostic diagnostic, int style) {
        super(diagnostic, style);
    }

    @Override
    public boolean isValid(String value) {
        try {
            if (this.hasStyle(Basics.FLOATING_POINT)) {
                double number = Double.valueOf(value);
                if (this.hasStyle(Basics.POSITIVE) && number < 0.0) {
                    return false;
                }
                if (this.hasStyle(Basics.NOT_ZERO) && number == 0.0) {
                    return false;
                }
            } else {
                int number = Integer.valueOf(value);
                if (this.hasStyle(Basics.POSITIVE) && number < 0) {
                    return false;
                }
                if (this.hasStyle(Basics.NOT_ZERO) && number == 0) {
                    return false;
                }
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }
}

