/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.CondExp;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ExternalFunctionRef;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.FunctionRef;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PatternExp;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;

public class ExpressionUtil
extends ModelVisitor.Stub {
    private final HashSet<Variable> variableSet = new HashSet();
    private final boolean onlyModified;

    public static Set<Variable> findUsedVariables(Exp exp) {
        if (exp == null) {
            return Collections.emptySet();
        }
        ExpressionUtil visitor = new ExpressionUtil();
        exp.accept(visitor);
        return visitor.getVariableSet();
    }

    public static Set<Variable> findUsedVariables(Pattern pattern) {
        if (pattern == null) {
            return Collections.emptySet();
        }
        ExpressionUtil visitor = new ExpressionUtil();
        pattern.accept(visitor);
        return visitor.getVariableSet();
    }

    public static Set<Variable> findModifiedVariables(Pattern exp) {
        if (exp == null) {
            return Collections.emptySet();
        }
        ExpressionUtil visitor = new ExpressionUtil(true);
        exp.accept(visitor);
        return visitor.getVariableSet();
    }

    public ExpressionUtil() {
        this(false);
    }

    public ExpressionUtil(boolean onlyModified) {
        this.onlyModified = onlyModified;
    }

    public HashSet<Variable> getVariableSet() {
        return this.variableSet;
    }

    @Override
    public void visitVarRef(VarRef toVisit) {
        this.variableSet.add(toVisit.getDecl());
    }

    @Override
    public void visitUnExp(UnExp toVisit) {
        toVisit.getExp().accept(this);
    }

    @Override
    public void visitBinExp(BinExp toVisit) {
        toVisit.getLeft().accept(this);
        toVisit.getRight().accept(this);
    }

    @Override
    public void visitNatLiteral(NatLiteral toVisit) {
    }

    @Override
    public void visitBoolLiteral(BoolLiteral toVisit) {
    }

    @Override
    public void visitArrayElem(ArrayElem toVisit) {
        toVisit.getArray().accept(this);
        toVisit.getIndex().accept(this);
    }

    @Override
    public void visitRecordElem(RecordElem toVisit) {
        toVisit.getRecord().accept(this);
    }

    @Override
    public void visitInlineQueue(InlineQueue toVisit) {
        for (Exp elem : toVisit.getElemList()) {
            elem.accept(this);
        }
    }

    @Override
    public void visitInlineArray(InlineArray toVisit) {
        for (Exp elem : toVisit.getElemList()) {
            elem.accept(this);
        }
    }

    @Override
    public void visitInlineRecord(InlineRecord toVisit) {
        for (ValuedField field : toVisit.getValueList()) {
            field.getValue().accept(this);
        }
    }

    @Override
    public void visitConstrExp(ConstrExp toVisit) {
        if (toVisit.getArg() != null) {
            toVisit.getArg().accept(this);
        }
    }

    @Override
    public void visitConstantRef(ConstantRef toVisit) {
    }

    @Override
    public void visitCondExp(CondExp toVisit) {
        toVisit.getCond().accept(this);
        toVisit.getIft().accept(this);
        toVisit.getIff().accept(this);
    }

    @Override
    public void visitAnyPattern(AnyPattern toVisit) {
    }

    @Override
    public void visitArrayPattern(ArrayPattern toVisit) {
        toVisit.getArray().accept(this);
        if (!this.onlyModified) {
            toVisit.getIndex().accept(this);
        }
    }

    @Override
    public void visitFieldPattern(FieldPattern toVisit) {
        toVisit.getRecord().accept(this);
    }

    @Override
    public void visitConstrPattern(ConstrPattern toVisit) {
        if (toVisit.getArg() != null) {
            toVisit.getArg().accept(this);
        }
    }

    @Override
    public void visitPatternExp(PatternExp toVisit) {
        toVisit.getExp().accept(this);
        toVisit.getPattern().accept(this);
    }

    @Override
    public void visitFunctionRef(FunctionRef toVisit) {
        for (Exp e : toVisit.getParamList()) {
            e.accept(this);
        }
    }

    @Override
    public void visitExternalFunctionRef(ExternalFunctionRef toVisit) {
        for (Exp e : toVisit.getParamList()) {
            e.accept(this);
        }
    }
}

