/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.transfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ModelCloner;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NonDeterministicAssignment;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.PatternStmt;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Program;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Synchronization;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.UnOp;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;
import obp.fiacre.util.FiacreBuilder;
import obp.fiacre.util.FiacrePrinter;
import obp.fiacre.util.FiacreUtil;

public class BranchSplitter {
    public static void main(String[] args) {
        try {
            File inputPath = new File(args[0]);
            Program program = FiacreUtil.loadProgram(inputPath);
            Transformer splitter = new Transformer();
            splitter.visitProgram(program);
            File outputPath = new File(inputPath.getParentFile(), "splitted_" + inputPath.getName());
            outputPath.getAbsoluteFile().getParentFile().mkdirs();
            outputPath.createNewFile();
            BufferedWriter os = new BufferedWriter(new FileWriter(outputPath));
            os.write(FiacrePrinter.toString((Program)splitter.popObject(Program.class)));
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class Transformer
    extends ModelCloner {
        Transformer() {
        }

        @Override
        public void visitProcessDecl(ProcessDecl toVisit) {
            ProcessDecl cloned = new ProcessDecl();
            for (String string : toVisit.getCommentList()) {
                cloned.addComment(string);
            }
            cloned.setName(toVisit.getName());
            this.registerClone(toVisit, cloned);
            for (ArgumentVariable argumentVariable : toVisit.getArgList()) {
                argumentVariable.accept(this);
                cloned.addArg((ArgumentVariable)this.popObject(ArgumentVariable.class));
            }
            for (LocalVariable localVariable : toVisit.getVarList()) {
                localVariable.accept(this);
                cloned.addVar((LocalVariable)this.popObject(LocalVariable.class));
            }
            for (ParamPortDecl paramPortDecl : toVisit.getPortList()) {
                paramPortDecl.accept(this);
                cloned.addPort((ParamPortDecl)this.popObject(ParamPortDecl.class));
            }
            for (LocalPortDecl localPortDecl : toVisit.getLocalPortList()) {
                localPortDecl.accept(this);
                cloned.addLocalPort((LocalPortDecl)this.popObject(LocalPortDecl.class));
            }
            for (State state : toVisit.getStateList()) {
                state.accept(this);
                cloned.addState((State)this.popObject(State.class));
            }
            if (toVisit.getInitAction() != null) {
                toVisit.getInitAction().accept(this);
                cloned.setInitAction((Statement)this.popObject(Statement.class));
            }
            for (Transition transition : toVisit.getTransitionList()) {
                TransitionSplitter tS = new TransitionSplitter(this);
                transition.accept(tS);
                cloned.addAllTransition(tS.transitions);
            }
            this.pushObject(cloned);
        }

        class TransitionSplitter
        extends ModelVisitor.Stub {
            List<Transition> transitions = new ArrayList<Transition>();
            Stack<List<Statement>> returnStack;
            private ModelCloner clonner;
            FiacreBuilder builder = new FiacreBuilder();

            public TransitionSplitter(ModelCloner clonner) {
                this.clonner = clonner;
            }

            @Override
            public void visitTransition(Transition toVisit) {
                this.returnStack = new Stack();
                if (toVisit.getAction() != null) {
                    toVisit.getAction().accept(this);
                    Transition t = new Transition();
                    t.setName(toVisit.getName());
                    toVisit.getFrom().accept(this.clonner);
                    t.setFrom((State)this.clonner.popObject(State.class));
                    Select select = new Select();
                    t.setAction(select);
                    for (Statement branch : this.returnStack.pop()) {
                        select.addStatement(branch);
                        System.err.println(FiacrePrinter.toString(branch) + "\n--------\n");
                    }
                    this.transitions.add(t);
                }
            }

            @Override
            public void visitSeq(Seq toVisit) {
                toVisit.getStatement(0).accept(this);
                ArrayList<Seq> currentBranches = new ArrayList<Seq>();
                for (Statement s : this.returnStack.pop()) {
                    if (s instanceof Seq) {
                        currentBranches.add((Seq)s);
                        continue;
                    }
                    Seq seq = new Seq();
                    seq.addStatement(s);
                    currentBranches.add(seq);
                }
                for (int i = 1; i < toVisit.getStatementCount(); ++i) {
                    ArrayList<Seq> newBranches = new ArrayList<Seq>();
                    for (Statement statement : currentBranches) {
                        toVisit.getStatement(i).accept(this);
                        for (Statement s : this.returnStack.pop()) {
                            statement.accept(this.clonner);
                            Seq seq = (Seq)this.clonner.popObject(Seq.class);
                            seq.addStatement(s);
                            newBranches.add(seq);
                        }
                    }
                    currentBranches = newBranches;
                }
                this.returnStack.push(currentBranches);
            }

            @Override
            public void visitSelect(Select toVisit) {
                ArrayList branches = new ArrayList();
                for (Statement stmt : toVisit.getStatementList()) {
                    stmt.accept(this);
                    branches.addAll(this.returnStack.pop());
                }
                this.returnStack.push(branches);
            }

            @Override
            public void visitIfStmt(IfStmt toVisit) {
                ArrayList<Seq> branches = new ArrayList<Seq>();
                toVisit.getThen().accept(this);
                for (Statement trueBranch : this.returnStack.pop()) {
                    toVisit.getCondition().accept(this.clonner);
                    Exp trueCond = (Exp)this.clonner.popObject(Exp.class);
                    Seq sequence = new Seq();
                    sequence.addStatement(this.builder.onStmt(trueCond));
                    if (trueBranch instanceof Seq) {
                        sequence.addAllStatement(((Seq)trueBranch).getStatementList());
                    } else {
                        sequence.addStatement(trueBranch);
                    }
                    branches.add(sequence);
                }
                if (toVisit.getElse() != null) {
                    toVisit.getElse().accept(this);
                    for (Statement falseBranch : this.returnStack.pop()) {
                        toVisit.getCondition().accept(this.clonner);
                        Exp toNegate = (Exp)this.clonner.popObject(Exp.class);
                        UnExp falseCond = new UnExp();
                        falseCond.setUnop(UnOp.UNOT);
                        falseCond.setExp(toNegate);
                        Seq sequence = new Seq();
                        sequence.addStatement(this.builder.onStmt(falseCond));
                        if (falseBranch instanceof Seq) {
                            sequence.addAllStatement(((Seq)falseBranch).getStatementList());
                        } else {
                            sequence.addStatement(falseBranch);
                        }
                        branches.add(sequence);
                    }
                } else {
                    toVisit.getCondition().accept(this.clonner);
                    Exp toNegate = (Exp)this.clonner.popObject(Exp.class);
                    UnExp falseCond = new UnExp();
                    falseCond.setUnop(UnOp.UNOT);
                    falseCond.setExp(toNegate);
                    Seq sequence = new Seq();
                    sequence.addStatement(this.builder.onStmt(falseCond));
                    branches.add(sequence);
                }
                this.returnStack.push(branches);
            }

            @Override
            public void visitCaseStmt(CaseStmt toVisit) {
                ArrayList<Seq> branches = new ArrayList<Seq>();
                for (Rule rule : toVisit.getRuleList()) {
                    rule.getAction().accept(this);
                    for (Statement branch : this.returnStack.pop()) {
                        Exp rhs;
                        toVisit.getExp().accept(this.clonner);
                        Exp lhs = (Exp)this.clonner.popObject(Exp.class);
                        rule.getLhs().accept(this.clonner);
                        if (rule.getLhs() instanceof ConstrPattern) {
                            if (((ConstrPattern)rule.getLhs()).getArg() != null) {
                                throw new IllegalArgumentException("unsupported yet union patterns in BranchSplitter ");
                            }
                            rhs = new ConstrExp();
                            ((ConstrExp)rhs).setName(((ConstrPattern)rule.getLhs()).getName());
                        } else {
                            rhs = (Exp)this.clonner.popObject(Exp.class);
                        }
                        BinExp condition = new BinExp();
                        condition.setBinOp(BinOp.BEQ);
                        condition.setLeft(lhs);
                        condition.setRight(rhs);
                        Seq sequence = new Seq();
                        sequence.addStatement(this.builder.onStmt(condition));
                        if (branch instanceof Seq) {
                            sequence.addAllStatement(((Seq)branch).getStatementList());
                        } else {
                            sequence.addStatement(branch);
                        }
                        branches.add(sequence);
                    }
                }
                this.returnStack.push(branches);
            }

            @Override
            public void visitNullStmt(NullStmt toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitDeterministicAssignment(DeterministicAssignment toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitNonDeterministicAssignment(NonDeterministicAssignment toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitReception(Reception toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitEmission(Emission toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitSynchronization(Synchronization toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitWhileStmt(WhileStmt toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitTo(To toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitWait(Wait toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitForeach(Foreach toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }

            @Override
            public void visitPatternStmt(PatternStmt toVisit) {
                toVisit.accept(this.clonner);
                this.returnStack.push(Collections.singletonList(this.clonner.popObject(Statement.class)));
            }
        }
    }
}

