/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ModelVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public abstract class InlineCollection
implements BoostObject,
Exp {
    private final List<Exp> elemList = new ArrayList<Exp>();

    public InlineCollection() {
    }

    protected InlineCollection(Boost boost) {
        boost.register((BoostObject)this);
        for (Exp oneChild : BoostUtil.readObjectList((Boost)boost, Exp.class)) {
            this.elemList.add(oneChild);
        }
    }

    public List<Exp> getElemList() {
        return Collections.unmodifiableList(this.elemList);
    }

    public int getElemCount() {
        return this.elemList.size();
    }

    public Exp getElem(int index) {
        if (index < 0 || index >= this.getElemCount()) {
            return null;
        }
        return this.elemList.get(index);
    }

    public void addElem(Exp newValue) {
        this.addElem(this.getElemCount(), newValue);
    }

    public void addElem(int index, Exp newValue) {
        this.elemList.add(index, newValue);
    }

    public Exp setElem(int index, Exp newValue) {
        return this.elemList.set(index, newValue);
    }

    public void addAllElem(Collection<Exp> toAddList) {
        for (Exp newValue : toAddList) {
            this.addElem(this.getElemCount(), newValue);
        }
    }

    public void removeElem(Exp value) {
        int index = this.elemList.indexOf(value);
        if (index >= 0) {
            this.removeElem(index);
        }
    }

    public void removeElem(int index) {
        this.elemList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        BoostUtil.writeObjectCollection((Boost)boost, this.elemList);
    }

    @Override
    public abstract void accept(ModelVisitor var1);
}

