/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.NamedElement;
import obp.if2.data.constants.NamedConstant;
import obp.if2.data.types.complex.DerivedType;
import obp.if2.data.variables.Variable;
import obp.if2.external.Procedure;

public abstract class Entity
implements NamedElement {
    private final List<NamedConstant> constantsList = new ArrayList<NamedConstant>();
    private final List<DerivedType> typesList = new ArrayList<DerivedType>();
    private final List<Variable> variablesList = new ArrayList<Variable>();
    private final List<Procedure> proceduresList = new ArrayList<Procedure>();
    private String name;

    public List<NamedConstant> getConstantsList() {
        return Collections.unmodifiableList(this.constantsList);
    }

    public int getConstantsCount() {
        return this.constantsList.size();
    }

    public NamedConstant getConstants(int index) {
        if (index < 0 || index >= this.getConstantsCount()) {
            return null;
        }
        return this.constantsList.get(index);
    }

    public void addConstants(NamedConstant newValue) {
        this.addConstants(this.getConstantsCount(), newValue);
    }

    public void addConstants(int index, NamedConstant newValue) {
        this.constantsList.add(index, newValue);
    }

    public NamedConstant setConstants(int index, NamedConstant newValue) {
        return this.constantsList.set(index, newValue);
    }

    public void addAllConstants(Collection<NamedConstant> toAddList) {
        for (NamedConstant newValue : toAddList) {
            this.addConstants(this.getConstantsCount(), newValue);
        }
    }

    public void removeConstants(NamedConstant value) {
        int index = this.constantsList.indexOf(value);
        if (index >= 0) {
            this.removeConstants(index);
        }
    }

    public void removeConstants(int index) {
        this.constantsList.remove(index);
    }

    public void addConstantsAndOpposite(NamedConstant newValue) {
        this.addConstants(newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
    }

    public void addAllConstantsAndOpposite(Collection<NamedConstant> toAddList) {
        for (NamedConstant newValue : toAddList) {
            this.addConstantsAndOpposite(this.getConstantsCount(), newValue);
        }
    }

    public void addConstantsAndOpposite(int index, NamedConstant newValue) {
        this.addConstants(index, newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
    }

    public NamedConstant setConstantsAndOpposite(int index, NamedConstant newValue) {
        NamedConstant oldValue = this.constantsList.set(index, newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
        return oldValue;
    }

    public void removeConstantsAndOpposite(NamedConstant removed) {
        this.removeConstants(removed);
        if (removed != null) {
            removed.setEntity(null);
        }
    }

    public void removeConstantsAndOpposite(int index) {
        NamedConstant removed = this.constantsList.get(index);
        this.removeConstants(index);
        if (removed != null) {
            removed.setEntity(null);
        }
    }

    public List<DerivedType> getTypesList() {
        return Collections.unmodifiableList(this.typesList);
    }

    public int getTypesCount() {
        return this.typesList.size();
    }

    public DerivedType getTypes(int index) {
        if (index < 0 || index >= this.getTypesCount()) {
            return null;
        }
        return this.typesList.get(index);
    }

    public void addTypes(DerivedType newValue) {
        this.addTypes(this.getTypesCount(), newValue);
    }

    public void addTypes(int index, DerivedType newValue) {
        this.typesList.add(index, newValue);
    }

    public DerivedType setTypes(int index, DerivedType newValue) {
        return this.typesList.set(index, newValue);
    }

    public void addAllTypes(Collection<DerivedType> toAddList) {
        for (DerivedType newValue : toAddList) {
            this.addTypes(this.getTypesCount(), newValue);
        }
    }

    public void removeTypes(DerivedType value) {
        int index = this.typesList.indexOf(value);
        if (index >= 0) {
            this.removeTypes(index);
        }
    }

    public void removeTypes(int index) {
        this.typesList.remove(index);
    }

    public void addTypesAndOpposite(DerivedType newValue) {
        this.addTypes(newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
    }

    public void addAllTypesAndOpposite(Collection<DerivedType> toAddList) {
        for (DerivedType newValue : toAddList) {
            this.addTypesAndOpposite(this.getTypesCount(), newValue);
        }
    }

    public void addTypesAndOpposite(int index, DerivedType newValue) {
        this.addTypes(index, newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
    }

    public DerivedType setTypesAndOpposite(int index, DerivedType newValue) {
        DerivedType oldValue = this.typesList.set(index, newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
        return oldValue;
    }

    public void removeTypesAndOpposite(DerivedType removed) {
        this.removeTypes(removed);
        if (removed != null) {
            removed.setEntity(null);
        }
    }

    public void removeTypesAndOpposite(int index) {
        DerivedType removed = this.typesList.get(index);
        this.removeTypes(index);
        if (removed != null) {
            removed.setEntity(null);
        }
    }

    public List<Variable> getVariablesList() {
        return Collections.unmodifiableList(this.variablesList);
    }

    public int getVariablesCount() {
        return this.variablesList.size();
    }

    public Variable getVariables(int index) {
        if (index < 0 || index >= this.getVariablesCount()) {
            return null;
        }
        return this.variablesList.get(index);
    }

    public void addVariables(Variable newValue) {
        this.addVariables(this.getVariablesCount(), newValue);
    }

    public void addVariables(int index, Variable newValue) {
        this.variablesList.add(index, newValue);
    }

    public Variable setVariables(int index, Variable newValue) {
        return this.variablesList.set(index, newValue);
    }

    public void addAllVariables(Collection<Variable> toAddList) {
        for (Variable newValue : toAddList) {
            this.addVariables(this.getVariablesCount(), newValue);
        }
    }

    public void removeVariables(Variable value) {
        int index = this.variablesList.indexOf(value);
        if (index >= 0) {
            this.removeVariables(index);
        }
    }

    public void removeVariables(int index) {
        this.variablesList.remove(index);
    }

    public void addVariablesAndOpposite(Variable newValue) {
        this.addVariables(newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
    }

    public void addAllVariablesAndOpposite(Collection<Variable> toAddList) {
        for (Variable newValue : toAddList) {
            this.addVariablesAndOpposite(this.getVariablesCount(), newValue);
        }
    }

    public void addVariablesAndOpposite(int index, Variable newValue) {
        this.addVariables(index, newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
    }

    public Variable setVariablesAndOpposite(int index, Variable newValue) {
        Variable oldValue = this.variablesList.set(index, newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
        return oldValue;
    }

    public void removeVariablesAndOpposite(Variable removed) {
        this.removeVariables(removed);
        if (removed != null) {
            removed.setEntity(null);
        }
    }

    public void removeVariablesAndOpposite(int index) {
        Variable removed = this.variablesList.get(index);
        this.removeVariables(index);
        if (removed != null) {
            removed.setEntity(null);
        }
    }

    public List<Procedure> getProceduresList() {
        return Collections.unmodifiableList(this.proceduresList);
    }

    public int getProceduresCount() {
        return this.proceduresList.size();
    }

    public Procedure getProcedures(int index) {
        if (index < 0 || index >= this.getProceduresCount()) {
            return null;
        }
        return this.proceduresList.get(index);
    }

    public void addProcedures(Procedure newValue) {
        this.addProcedures(this.getProceduresCount(), newValue);
    }

    public void addProcedures(int index, Procedure newValue) {
        this.proceduresList.add(index, newValue);
    }

    public Procedure setProcedures(int index, Procedure newValue) {
        return this.proceduresList.set(index, newValue);
    }

    public void addAllProcedures(Collection<Procedure> toAddList) {
        for (Procedure newValue : toAddList) {
            this.addProcedures(this.getProceduresCount(), newValue);
        }
    }

    public void removeProcedures(Procedure value) {
        int index = this.proceduresList.indexOf(value);
        if (index >= 0) {
            this.removeProcedures(index);
        }
    }

    public void removeProcedures(int index) {
        this.proceduresList.remove(index);
    }

    public void addProceduresAndOpposite(Procedure newValue) {
        this.addProcedures(newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
    }

    public void addAllProceduresAndOpposite(Collection<Procedure> toAddList) {
        for (Procedure newValue : toAddList) {
            this.addProceduresAndOpposite(this.getProceduresCount(), newValue);
        }
    }

    public void addProceduresAndOpposite(int index, Procedure newValue) {
        this.addProcedures(index, newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
    }

    public Procedure setProceduresAndOpposite(int index, Procedure newValue) {
        Procedure oldValue = this.proceduresList.set(index, newValue);
        if (newValue != null) {
            newValue.setEntity(this);
        }
        return oldValue;
    }

    public void removeProceduresAndOpposite(Procedure removed) {
        this.removeProcedures(removed);
        if (removed != null) {
            removed.setEntity(null);
        }
    }

    public void removeProceduresAndOpposite(int index) {
        Procedure removed = this.proceduresList.get(index);
        this.removeProcedures(index);
        if (removed != null) {
            removed.setEntity(null);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public abstract void accept(If2Visitor var1);
}

